# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# conafchile_pts

library(testthat)

# Test 1: Confirm the object is a data.frame
test_that("conafchile_pts is a data.frame", {
  expect_s3_class(conafchile_pts, "data.frame")
})

# Test 2: Confirm it has exactly 30 columns
test_that("conafchile_pts has 30 columns", {
  expect_equal(length(conafchile_pts), 30)
})

# Test 3: Confirm it has exactly 5234 rows
test_that("conafchile_pts has 5234 rows", {
  expect_equal(nrow(conafchile_pts), 5234)
})

# Test 4: Confirm column names are correct
test_that("conafchile_pts has correct column names", {
  expect_named(conafchile_pts, c(
    "X", "temporada", "codreg", "codprov", "codcom", "ambito",
    "numero", "nombre_inc", "utm_este", "utm_norte", "inicio_c", "combus_i",
    "causa_gene", "causa_espe", "pino_0010", "pino_11_17", "pino_18", "eucalipto",
    "otras_plan", "total_plan", "arbolado", "matorral", "pastizal", "total_veg",
    "agricola", "desechos", "total_otra", "sup_t_a", "long", "lat"
  ))
})

# Test 5: Confirm column types are as expected
test_that("conafchile_pts columns have correct types", {
  expect_type(conafchile_pts$X, "integer")
  expect_type(conafchile_pts$temporada, "character")
  expect_type(conafchile_pts$codreg, "integer")
  expect_type(conafchile_pts$codprov, "integer")
  expect_type(conafchile_pts$codcom, "integer")
  expect_type(conafchile_pts$ambito, "character")
  expect_type(conafchile_pts$numero, "double")
  expect_type(conafchile_pts$nombre_inc, "character")
  expect_type(conafchile_pts$utm_este, "double")
  expect_type(conafchile_pts$utm_norte, "double")
  expect_type(conafchile_pts$inicio_c, "character")
  expect_type(conafchile_pts$combus_i, "character")
  expect_type(conafchile_pts$causa_gene, "double")
  expect_type(conafchile_pts$causa_espe, "character")
  expect_type(conafchile_pts$pino_0010, "double")
  expect_type(conafchile_pts$pino_11_17, "double")
  expect_type(conafchile_pts$pino_18, "double")
  expect_type(conafchile_pts$eucalipto, "double")
  expect_type(conafchile_pts$otras_plan, "double")
  expect_type(conafchile_pts$total_plan, "double")
  expect_type(conafchile_pts$arbolado, "double")
  expect_type(conafchile_pts$matorral, "double")
  expect_type(conafchile_pts$pastizal, "double")
  expect_type(conafchile_pts$total_veg, "double")
  expect_type(conafchile_pts$agricola, "double")
  expect_type(conafchile_pts$desechos, "double")
  expect_type(conafchile_pts$total_otra, "double")
  expect_type(conafchile_pts$sup_t_a, "double")
  expect_type(conafchile_pts$long, "double")
  expect_type(conafchile_pts$lat, "double")
})
