% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translations.R
\name{mwTranslations}
\alias{mwTranslations}
\title{Translate UI titles and labels}
\usage{
mwTranslations(
  settings = "Settings",
  chart = "Chart",
  compare = "Compare",
  compareVars = "Variables to compare",
  ncol = "Nb Columns",
  ncharts = "Nb Charts"
)
}
\arguments{
\item{settings}{Title of the settings panel.}

\item{chart}{Title of the chart panel.}

\item{compare}{Label of the checkbox that activate the comparison mode.}

\item{compareVars}{Label of the input containing the list of variables to compare.}

\item{ncol}{Label of the input that sets the number of columns.}

\item{ncharts}{Label of the input that sets the number of charts.}
}
\value{
Named list of translation strings.
}
\description{
Creates a list of translation strings that can be passed to function
\code{\link{manipulateWidget}} to translate some UI elements.
}
\examples{
translations <- mwTranslations(
  settings = "Parametres", chart = "Graphique", compare = "Comparaison",
  compareVars = "Variable de comparaison", ncharts = "Nb graph.", ncol = "Nb col."
)

if (require(dygraphs)) {
  mydata <- data.frame(year = 2000+1:100, value = rnorm(100))
  manipulateWidget(dygraph(mydata[range[1]:range[2] - 2000, ], main = title),
                   range = mwSlider(2001, 2100, c(2001, 2100)),
                   title = mwText("Fictive time series"),
                   .translations = translations)
}

}
