% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{select_rowcol_piece_byname}
\alias{select_rowcol_piece_byname}
\title{Select or remove rows or columns based on pieces of the names.}
\usage{
select_rowcol_piece_byname(
  a,
  retain = NULL,
  remove = NULL,
  piece = "all",
  pattern_type = "exact",
  prepositions = RCLabels::prepositions_list,
  notation = RCLabels::notations_list,
  inf_notation = TRUE,
  choose_most_specific = FALSE,
  margin = c(1, 2)
)
}
\arguments{
\item{a}{A matrix or list of matrices whose rows or columns are to be selected.}

\item{retain}{The row or column names to be retained.
Default is \code{NULL}, meaning that removal is requested.}

\item{remove}{The row or column names to be removed.
Default is \code{NULL}, meaning that retaining is requested.}

\item{piece}{The piece of row or column names to be assessed.
Default is "all", indicating that the entire label will be assessed.}

\item{pattern_type}{The way to match label pieces.
\code{pattern_type} is passed to \code{\link[RCLabels:make_or_pattern]{RCLabels::make_or_pattern()}}.
See \code{\link[RCLabels:make_or_pattern]{RCLabels::make_or_pattern()}} for details.
Default is "exact", meaning that exact matches are retained or removed.
Other options are "leading", "trailing", "anywhere", and "literal".}

\item{prepositions}{The prepositions that can be used for identifying pieces.
Default is \link[RCLabels:prepositions_list]{RCLabels::prepositions_list}.}

\item{notation}{The notation for the row and column names.
Default is \link[RCLabels:notations_list]{RCLabels::notations_list}, meaning that all notations known to
\code{RCLabels} will be assessed.}

\item{inf_notation}{A boolean that tells whether to infer notation for rows and columns.
Default is \code{TRUE}.
See \code{\link[RCLabels:infer_notation]{RCLabels::infer_notation()}} for details.}

\item{choose_most_specific}{A boolean that tells whether to choose the most specific
notation from \code{notation} when inferring notation.
Default is \code{FALSE} so that a less specific notation can be
inferred.
In combination with \link[RCLabels:notations_list]{RCLabels::notations_list},
the default value of \code{FALSE} means that
\link[RCLabels:bracket_notation]{RCLabels::bracket_notation} will be selected instead of
anything more specific, such as
\link[RCLabels:from_notation]{RCLabels::from_notation}.}

\item{margin}{The margin to which row or column removal is requested.
\code{1} indicates rows; \code{2} indicates columns.
Default is \code{c(1, 2)}, meaning that action should be taken on both rows and columns.}
}
\value{
\code{a} with rows and/or column retained or removed.
}
\description{
\code{select_rows_byname()} and \code{select_cols_byname()}
select rows and columns using regex patterns
This function performs similar actions
based on the pieces of row and column labels.
}
\details{
This function uses the \code{RCLabels} package to match
row and column names by pieces.

To retain rows or columns, specify \code{retain}.
To remove rows or columns, specify \code{remove}.

If \code{a} has row and column types, a string may be passed to \code{margin},
in which case the margin will be resolved.
See examples.

\code{notation} may be a list of notations that could apply in \code{a}.
This function will try to infer the notation that applies
to row and column names.

Retaining takes precedence over removing, always.

Options for \code{piece} are
\itemize{
\item "all" (the default), meaning that the entire label will be matched,
\item "pref", meaning that the prefix will be matched,
\item "suff", meaning that the suffix will be matched,
\item "noun", meaning that the first part will be matched, and
\item "from" (or another preposition), meaning that the object of that preposition will be matched.
}

If retaining or removing rows or columns results in no rows or columns remaining
in the matrix, \code{NULL} is returned.
}
\examples{
m <- matrix(1:4, nrow = 2, ncol = 2, byrow = TRUE, 
              dimnames = list(c("r1 [to a]", "r2 [to b]"), 
                              c("c1 [from c]", "c2 [from d]"))) \%>\% 
  setrowtype("rows") \%>\% setcoltype("cols")
m
select_rowcol_piece_byname(m, retain = "r1", piece = "noun", 
                           notation = RCLabels::to_notation, 
                           margin = 1)
select_rowcol_piece_byname(m, retain = "b", piece = "to", 
                           notation = RCLabels::bracket_notation, 
                           margin = 1)
select_rowcol_piece_byname(m, retain = "c1", piece = "noun",
                           notation = RCLabels::bracket_notation, 
                           margin = 2)
select_rowcol_piece_byname(m, retain = "d", piece = "from", 
                           notation = RCLabels::bracket_notation, 
                           margin = 2)
select_rowcol_piece_byname(m, retain = "c", piece = "from", 
                           notation = RCLabels::bracket_notation, 
                           margin = 2)
select_rowcol_piece_byname(m, retain = "b", piece = "to", 
                           notation = RCLabels::bracket_notation, 
                           margin = "rows")
select_rowcol_piece_byname(m, retain = "c", piece = "from", 
                           notation = RCLabels::bracket_notation, 
                           margin = "cols")
}
