% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbX_functions.R
\name{ezviz}
\alias{ezviz}
\title{Visualize Microbiome Data}
\usage{
ezviz(
  microbiome_data,
  metadata,
  level,
  selected_metadata,
  top_taxa = NULL,
  threshold = NULL,
  flip = FALSE
)
}
\arguments{
\item{microbiome_data}{A string specifying the path to the microbiome data file.}

\item{metadata}{A string specifying the path to the metadata file.}

\item{level}{A string indicating the taxonomic level for filtering the data (e.g., "genus").}

\item{selected_metadata}{A string specifying the metadata column used for grouping.}

\item{top_taxa}{An optional numeric value indicating the number of top taxa to keep. Use this OR
threshold, but not both.}

\item{threshold}{An optional numeric value indicating the minimum threshold value; taxa below this
threshold will be grouped into an "Other" category.}

\item{flip}{Logical. If `TRUE`, the order of the stacks is reversed.}
}
\value{
A ggplot object containing the visualization.
}
\description{
Generates publication-ready visualizations for microbiome data. This function first processes
the microbiome and metadata files using ezclean(), then creates a bar plot using ggplot2.
Supported file formats are CSV, TXT, and 'Excel'. Note: Only one of the parameters top_taxa or threshold
should be provided.
}
\examples{
\donttest{
mb  <- system.file("extdata", "microbiome.csv", package = "mbX")
md  <- system.file("extdata", "metadata.csv",   package = "mbX")
plot_obj <- ezviz(
  microbiome_data = mb,
  metadata        = md,
  level           = "genus",
  selected_metadata    = "sample_type",
  top_taxa        = 20,
  flip            = FALSE
)
print(plot_obj)
}

}
