% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBBE.R
\name{calc_power}
\alias{calc_power}
\title{Calculate Bioequivalence Power}
\usage{
calc_power(run_dir, samp_size, alpha, model_averaging_by, NTID)
}
\arguments{
\item{run_dir}{Character string specifying the run directory where simulation outputs are located.}

\item{samp_size}{Integer indicating the number of samples to be used in the analysis.}

\item{alpha}{Numeric value representing the alpha error rate. It must lie between 0 and 1.}

\item{model_averaging_by}{Character string indicating the method for model averaging, either "subject" or "study".}

\item{NTID}{Logical indicating if the drug being tested is a narrow therapeutic index drug.}
}
\value{
A list containing the results for:
\itemize{
\item \code{Cmax_result}: Power for the Cmax parameter.
\item \code{AUCinf_result}: Power for the AUCinf parameter.
\item \code{AUClast_result}: Power for the AUClast parameter.
All power values range between 0 and 1.
}
}
\description{
Computes the power for bioequivalence (BE) testing based on EMA standards statistics
applied to each Monte Carlo simulation. The power is determined by the proportion of
simulations that meet the BE criteria.
}
\details{
When the simulation is conducted by study (i.e., a unique model for each study),
this results in model averaging at the study level. If \code{model_averaging_by} is set to "subject",
data from different studies are merged. For each study dataset, subjects are randomly selected
(without replacement) from across all studies.

The function iterates over each sample, reading the corresponding NCAresults (designated by the
sample number). Subsequently, it determines if each sample meets or fails the BE testing criteria.
}
\examples{
calc_power(
 run_dir = system.file(package = "mbbe", "examples", "calc_power"),
 samp_size = 5,
 alpha = 0.05,
 model_averaging_by = "study",
 NTID = FALSE
)

}
