% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/assoc.R, R/conc.R, R/fnames.R,
%   R/freqlist.R, R/slma.R, R/tokenize.R, R/types.R
\name{as_data_frame}
\alias{as_data_frame}
\alias{as_data_frame.default}
\alias{as.data.frame.assoc_scores}
\alias{as.data.frame.conc}
\alias{as.data.frame.fnames}
\alias{as.data.frame.freqlist}
\alias{as.data.frame.details.slma}
\alias{as.data.frame.slma}
\alias{as.data.frame.tokens}
\alias{as.data.frame.types}
\title{Coerce object to a data frame}
\usage{
as_data_frame(x, row.names = NULL, optional = FALSE, ...)

\method{as_data_frame}{default}(x, row.names = NULL, optional = FALSE, ...)

\method{as.data.frame}{assoc_scores}(x, ...)

\method{as.data.frame}{conc}(x, ...)

\method{as.data.frame}{fnames}(x, ...)

\method{as.data.frame}{freqlist}(x, row.names = NULL, optional = FALSE, ...)

\method{as.data.frame}{details.slma}(x, ...)

\method{as.data.frame}{slma}(x, ...)

\method{as.data.frame}{tokens}(x, ...)

\method{as.data.frame}{types}(x, ...)
}
\arguments{
\item{x}{Object to coerce to \link{data.frame}.}

\item{row.names}{\code{NULL} or a character vector giving the rownames for the
dataframe.}

\item{optional}{Logical. If \code{TRUE}, setting rownames and converting column
names is optional (see \code{\link[=as.data.frame]{as.data.frame()}}).}

\item{...}{Additional arguments}
}
\value{
Object of class \code{\link{data.frame}}
}
\description{
\code{as_data_frame()} is an alternative to \code{\link[=as.data.frame]{as.data.frame()}}. A number of objects
in mclm can be turned into dataframes with one of these functions.
}
\examples{
# for an assoc_scores object ---------------------
a <- c(10,    30,    15,    1)
b <- c(200, 1000,  5000,  300)
c <- c(100,   14,    16,    4)
d <- c(300, 5000, 10000, 6000)
types <- c("four", "fictitious", "toy", "examples")
(scores <- assoc_abcd(a, b, c, d, types = types))

as.data.frame(scores)
as_data_frame(scores)

# for a conc object ------------------------------
(conc_data <- conc('A very small corpus.', '\\\\w+', as_text = TRUE))
as.data.frame(conc_data)

# for an fnames object ---------------------------
cwd_fnames <- as_fnames(c('file1', 'file2'))
as.data.frame(cwd_fnames)

# for a freqlist, types or tokens object ---------
toy_corpus <- "Once upon a time there was a tiny toy corpus.
  It consisted of three sentences. And it lived happily ever after."
(flist <- freqlist(toy_corpus, as_text = TRUE))
as.data.frame(flist)

(flist2 <- keep_re(flist, "^..?$"))
as.data.frame

(toks <- tokenize(toy_corpus))
as.data.frame(toks)

(toks <- tokenize(toy_corpus))
as.data.frame(toks)
}
