% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{write_types}
\alias{write_types}
\title{Write a vector of types to a text file}
\usage{
write_types(x, file, ...)
}
\arguments{
\item{x}{Object of class \code{\link{types}}.}

\item{file}{Name of the output file}

\item{...}{Additional arguments (not implemented).}
}
\value{
Invisibly, \code{x}.
}
\description{
This function writes an object of the class \code{\link{types}} to a text file. Each type
is written to a separate line. The file encoding that is used is
\code{"UTF-8"}.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
types <- as_types(c("first", "second", "third"))
write_types(types, "file_with_types.txt")
types_2 <- read_types("file_with_types.txt")
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link[=read_types]{read_types()}}

Other writing functions: 
\code{\link{write_assoc}()},
\code{\link{write_conc}()},
\code{\link{write_fnames}()},
\code{\link{write_freqlist}()},
\code{\link{write_tokens}()},
\code{\link{write_txt}()}
}
\concept{writing functions}
