% file man/bootMSD.Rd
% (c) 20017 S Ellison
\name{ bootMSD }
\Rdversion{1.1}
\alias{ bootMSD }
\alias{ bootMSD.MSD }
\alias{ bootMSD.default }

\title{ Parametric bootstrap for median scaled difference }
\description{
  Generates a parametric bootstrap for the median of scaled differences 
  from each point in a data set to all other points..
}
\usage{
        bootMSD(x, ...)

        \method{bootMSD}{default}(x, s = mad, B = 3000, probs = c(0.95, 0.99), 
                method = c("rnorm", "lhs"), keep = FALSE, labels = names(x), ...)

        \method{bootMSD}{MSD}(x, B = 3000, probs = c(0.95, 0.99), 
                method = c("rnorm", "lhs"), keep = FALSE, labels = names(x), ...)
	
}

\arguments{
	\item{x}{
	An R object. For the default method, a vector of observations. For the \code{MSD}
	method, an object of class \code{"MSD"}. For \code{print}, \code{summary} and \code{plot}
	methods, an object of class \code{"bootMSD"}. 
	}
  	\item{s}{Either a function returning an estimate of scale for \code{x} or a vector of 
  		length \code{length(x)} of standard errors or standard uncertainties in 
  		\code{x}.}
	 \item{B}{
		Scalar number of bootstrap replicates.
	}
	  \item{probs}{
		Vector of probabilities at which to calculate upper quantiles. Passed to
		\code{\link{quantile}}.
	}
	  \item{method}{
		Character value describing the simulation method. 
	}
	  \item{keep}{
		If \code{keep == TRUE} the individual bootstrap replicates are retained.
	}
	  \item{labels}{
		Character vector of labels for individual values.
	}
	  \item{\dots}{Parameters passed to other methods. }
}
\details{
	\code{bootMSD} calculates a parametric bootstrap simulation (or Monte carlo simulation)
	of the results of \code{\link{msd}} applied to data. This allows individual case-specific 
	quantiles and \emph{p}-values to be estimated that allow for different standard errors 
	(or standard uncertainties) \code{s}. 
	
	The sampling method is currently either sampling from \code{rnorm} or by latin hypercube sampling
	using \code{lhs}.
	
	Individual upper quantiles for probabilities \code{probs} and \emph{p}-values are estimated 
	directly from the bootstrap replicates. Quantiles use \code{\link{quantile}}. \emph{p}-values 
	are estimated from the proportion of replicates that exceed the observed MSD calculated by 
	\code{\link{msd}}. Note that the \code{print} method for the \code{summary} object does 
	not report zero proportions as identically zero. 	
}
\value{
	An object of class "bootMSD", consisting of a vector of length \code{length(x)} of median 
	scaled absolute deviations for each observation, with attributes:

	\item{msd}{vector of raw calculated MSD values calculated by \code{\link{msd}}}
	\item{labels}{character vector of labels, by default taken from \code{x}}
	\item{probs}{vextor of probabilities supplied and used for quantiles}
	\item{critical.values}{matrix of quantiles. Each row corresponds to a probability 
		  in \code{probs} and each column to an individual data point.}
	\item{pvals}{\emph{p}-values estimated as the observed proportion of
		simulated values exceeding the MSD value calculated by \code{msd}.}
	\item{B}{Number of bootstrap replicates used.}
	\item{method}{The sampling method used by the parametric bootstrap.}
	\item{t}{If \code{keep == TRUE}, the individual bootstrap replicates 
		generated by \code{bootMSD}. Set to \code{NA} if \code{keep == FALSE}.}
        
        Summary, print and plot methods are provided for the class; see \code{\link{bootMSD-class}}. 
}

\seealso{
  \code{\link{msd}}, \code{\link{bootMSD-class}}, \code{\link{print.bootMSD}}, 
  \code{\link{plot.bootMSD}}, \code{\link{summary.bootMSD}}.
}
\references{
Ellison, S. L. R. (2018) An outlier-resistant indicator of anomalies among 
inter-laboratory comparison data with associated uncertainty. _Metrologia_ 
(accepted 4 October 2018)

}
\author{
S. L. R. Ellison \email{s.ellison@lgcgroup.com}
}
\examples{

  data(Pb)
  \dontrun{
  #Default method:
  set.seed(1023)
  boot.Pb.default <- bootMSD(Pb$value, Pb$u)  # Uses individual standard uncertainties
  summary(boot.Pb.default)
  
  
  #Method for MSD object:
  msd.Pb<-msd(Pb$value, Pb$u)  # Uses individual standard uncertainties
  boot.Pb <- bootMSD(msd.Pb, B=5000)
  	#Increased replication compared to default
  summary(boot.Pb)
  
  # NOTE: The default summary gives individual observation p-values. 
  # To correct for multiple comparisons, apply 
  # a suitable p-value adjustment:
  summary(boot.Pb, p.adjust="holm")

  }


}


\keyword{ univar }
