% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANCOVA_statistics.R
\name{es_from_ancova_f}
\alias{es_from_ancova_f}
\title{Convert a F-statistic obtained from an ANCOVA model into several effect size measures.}
\usage{
es_from_ancova_f(
  ancova_f,
  cov_outcome_r,
  n_cov_ancova,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_ancova_f
)
}
\arguments{
\item{ancova_f}{a F-statistic from an ANCOVA (binary predictor)}

\item{cov_outcome_r}{correlation between the outcome and covariate(s) (multiple correlation when multiple covariates are included in the ANCOVA model).}

\item{n_cov_ancova}{number of covariates in the ANCOVA model.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the adjusted \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_ancova_f}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 18. Adjusted: ANCOVA statistics, eta-squared'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert a F-statistic obtained from an ANCOVA model into several effect size measures.
}
\details{
This function first computes an "adjusted" Cohen's d (D), and
Hedges' g (G) from the F-value of an ANCOVA (binary predictor).
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

\strong{To estimate a Cohen's d} the formula used is (table 12.3 in Cooper):
\deqn{cohen\_d =  \sqrt{ancova\_f * \frac{(n\_exp+n\_nexp)}{n\_exp*n\_nexp}} * \sqrt{1 - cov\_out\_cor^2}}

\strong{To estimate other effect size measures},
Calculations of the \code{\link{es_from_cohen_d_adj}()} are applied.
}
\examples{
es_from_ancova_f(ancova_f = 4, cov_outcome_r = 0.2, n_cov_ancova = 3, n_exp = 20, n_nexp = 20)
}
\references{
Cooper, H., Hedges, L. V., & Valentine, J. C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.
}
