% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANCOVA_means.R
\name{es_from_ancova_means_se}
\alias{es_from_ancova_means_se}
\title{Convert means and standard errors of two independent groups obtained from an ANCOVA model into several effect size measures}
\usage{
es_from_ancova_means_se(
  n_exp,
  n_nexp,
  ancova_mean_exp,
  ancova_mean_nexp,
  ancova_mean_se_exp,
  ancova_mean_se_nexp,
  cov_outcome_r,
  n_cov_ancova,
  smd_to_cor = "viechtbauer",
  reverse_ancova_means
)
}
\arguments{
\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{ancova_mean_exp}{adjusted mean of participants in the experimental/exposed group.}

\item{ancova_mean_nexp}{adjusted mean of participants in the non-experimental/non-exposed group.}

\item{ancova_mean_se_exp}{adjusted standard error of participants in the experimental/exposed group.}

\item{ancova_mean_se_nexp}{adjusted standard error of participants in the non-experimental/non-exposed group.}

\item{cov_outcome_r}{correlation between the outcome and covariate(s) (multiple correlation when multiple covariates are included in the ANCOVA model).}

\item{n_cov_ancova}{number of covariates in the ANCOVA model.}

\item{smd_to_cor}{formula used to convert the adjusted \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_ancova_means}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 19. Adjusted: Means and dispersion'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert means and standard errors of two independent groups obtained from an ANCOVA model into several effect size measures
}
\details{
This function converts the adjusted means standard errors of two independent groups
into standard deviations,
and then relies on the calculations of the \code{\link{es_from_ancova_means_sd}} function.

\strong{To convert the standard errors into standard deviations}, the following formula is used.
\deqn{ancova\_mean\_sd\_exp = ancova\_mean\_se\_exp * \sqrt{n\_exp}}
\deqn{ancova\_mean\_sd\_nexp = ancova\_mean\_se\_nexp * \sqrt{n\_nexp}}
Calculations of the \code{\link{es_from_ancova_means_sd}()} are then applied.
}
\examples{
es_from_ancova_means_se(
  n_exp = 55, n_nexp = 55,
  ancova_mean_exp = 2.3, ancova_mean_se_exp = 1.2,
  ancova_mean_nexp = 1.9, ancova_mean_se_nexp = 0.9,
  cov_outcome_r = 0.2, n_cov_ancova = 3
)
}
\references{
Higgins JPT, Li T, Deeks JJ (editors). Chapter 6: Choosing effect size measures and computing estimates of effect. In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). Cochrane Handbook for Systematic Reviews of Interventions version 6.3 (updated February 2022). Cochrane, 2022. Available from www.training.cochrane.org/handbook.
}
