% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_summary.R
\name{summary.metaConvert}
\alias{summary.metaConvert}
\title{Synthesize information of an object of class \dQuote{metaConvert} into a dataframe}
\usage{
\method{summary}{metaConvert}(object, digits = 3, ...)
}
\arguments{
\item{object}{an object of class \dQuote{metaConvert}}

\item{digits}{an integer value specifying the number of decimal places for the rounding of numeric values. Default is 3.}

\item{...}{other arguments that can be passed to the function}
}
\value{
This function returns a dataframe with many columns. We present below the information stored in each column of the returned dataframe

\strong{1. Raw user information.}
The first columns placed at the left of the returned dataset are simply information provided
by the users to facilitate the identification of each row.
If the following columns are missing in the original dataset, these columns will not appear in
the returned dataset.

\tabular{ll}{
\code{row_id} \tab Row number in the original dataset.\cr
\tab \cr
\code{study_id} \tab Identifier of the study.\cr
\tab \cr
\code{author} \tab Name of the author of the study.\cr
\tab \cr
\code{year} \tab Year of publication of the study.\cr
\tab \cr
\code{predictor} \tab Name of the predictor (intervention, risk factor, etc.).\cr
\tab \cr
\code{outcome} \tab Name of the outcome.\cr
\tab \cr
\code{info_expected} \tab Types of input data users expect to be used to estimate their effect size measure.\cr
\tab \cr
}

\strong{2. Information on generated effect sizes.}
Then, the function returns information on calculations. For example, users can retrieve
the effect size measure estimated, the number and type(s) of input data allowing to estimate the
chosen effect size measure, and the method used to obtain a unique effect size if overlapping
input data were available.
These columns could have several suffix.
\itemize{
\item If users requested to separate crude and adjusted estimates,
then the following columns will be presented with both a "_crude" suffix and a "_adjusted" suffix.
\item If users did not request to separate the presentation of crude and adjusted estimates, the following columns
will have no suffix.
}

For example, let's take column "all_info". It can be "all_info_crude" (all input data used to estimate any crude effect size),
"all_info_adjusted" (all input data leading to estimate any adjusted effect size),
or "all_info" (all input data leading to estimate any crude or adjusted effect sizes).

To facilitate the presentation, we thus refer to these columns as \code{name_of_the_column*},
the \code{*} meaning that it could end by _crude, _adjusted or "".

\tabular{ll}{
\code{all_info*} \tab list of input data available in the dataset that was used to estimate any effect size measure.\cr
\tab \cr
\code{measure*} \tab effect size measure requested by the user.\cr
\tab \cr
\code{info_measure*} \tab input data available to estimate the requested effect size measure.\cr
\tab \cr
\code{n_estimations*} \tab number of input data available to estimate the requested effect size measure.\cr
\tab \cr
\code{es_selected*} \tab method chosen by users to estimate the main effect size when overlapping data are present.\cr
\tab \cr
\code{info_used*} \tab type of input data used to estimate the main effect size.\cr
\tab \cr
}

\strong{3. Main effect size.}
The following columns contain the key information, namely, the main effect size + standard error + 95\% CI.

Again, the suffix of these columns can vary depending on the separation of effect sizes
estimated from crude and adjusted input data.

\tabular{ll}{
\code{es*} \tab main effect size value.\cr
\tab \cr
\code{se*} \tab standard error of the effect size.\cr
\tab \cr
\code{es_ci_lo*} \tab lower bound of the 95\% CI around the effect size.\cr
\tab \cr
\code{es_ci_up*} \tab upper bound of the 95\% CI around the effect size.\cr
\tab \cr
}

\strong{4. Overlapping effect sizes}
These columns are useful ONLY if a given comparison (i.e., row) has multiple input data
enabling to compute the requested effect size measure.

These columns identify the smallest/largest effect size per comparison,
and some indicators of consistency.

Again, the suffix of these columns can vary depending on the separation of effect sizes
estimated from crude and adjusted input data.

\tabular{ll}{
\code{min_info*} \tab type of input data leading to the smallest effect size for the comparison.\cr
\tab \cr
\code{min_es_value*} \tab smallest effect size value for the comparison.\cr
\tab \cr
\code{min_es_se*} \tab standard error of the smallest effect size for the comparison.\cr
\tab \cr
\code{min_es_ci_lo*} \tab lower bound of the 95\% CI of the smallest effect size for the comparison.\cr
\tab \cr
\code{min_es_ci_up*} \tab upper bound of the 95\% CI of the smallest effect size for the comparison.\cr
\tab \cr
}

\tabular{ll}{
\code{max_info*} \tab type of input data leading to the largest effect size for the comparison.\cr
\tab \cr
\code{max_es_value*} \tab largest effect size value for the comparison.\cr
\tab \cr
\code{max_es_se*} \tab standard error of the largest effect size for the comparison.\cr
\tab \cr
\code{max_es_ci_lo*} \tab lower bound of the 95\% CI of the largest effect size for the comparison.\cr
\tab \cr
\code{max_es_ci_up*} \tab upper bound of the 95\% CI of the largest effect size for the comparison.\cr
\tab \cr
}

\tabular{ll}{
\code{diff_min_max*} \tab difference between the smallest and largest effect size for the comparison.\cr
\tab \cr
\code{overlap_min_max*} \tab \% of overlap between the 95\% CIs of the largest/smallest effect sizes for the comparison.\cr
\tab \cr
\code{dispersion_es*} \tab standard deviation of all effect sizes for the comparison.\cr
\tab \cr
}
}
\description{
Synthesize information of an object of class \dQuote{metaConvert} into a dataframe
}
\details{
Summary method for objects of class \dQuote{metaConvert} produced by the \code{\link{convert_df}}
function. This function automatically:
\enumerate{
\item computes all effect sizes from all available input data
\item selects, if requested, a  main effect size for each association/comparison using the information passed by
the user in the \code{es_selected} argument of the \code{convert_df} function
\item identifies the smallest and largest effect size for each association/comparison
\item estimates the absolute difference between the smallest and largest effect size for each
association/comparison
\item estimates the percentage of overlap between the 95\% confidence intervals of the smallest and
largest effect size for each association/comparison
}
}
\examples{
### generate a summary of the results of an umbrella object
summary(
  convert_df(df.haza, measure = "g"),
  digits = 5)
}
\seealso{
\code{\link{metaConvert-package}} for the formatting of well-formatted datasets\cr
\code{\link{convert_df}} for estimating effect sizes from a dataset\cr
}
