% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_msn}
\alias{filter_msn}
\title{Filter Features based on occurrence of fragment ions}
\usage{
filter_msn(
  data,
  fragments,
  min_found,
  tolerance = 5,
  tolerance_type = "ppm",
  show_progress = TRUE
)
}
\arguments{
\item{data}{A data frame containing MSn spectra.}

\item{fragments}{A numeric. Exact mass of the fragment(s) to filter by.}

\item{min_found}{How many of the \code{fragments} must be found in order to keep the row? If \code{min_found = length(fragments)}, all fragments must be found.}

\item{tolerance}{A numeric. The tolerance to apply to the fragments. Either an absolute value in Da (if \code{tolerance_type = "absolute"}) or in ppm (if \code{tolerance_type = "ppm"}).}

\item{tolerance_type}{Either \code{"absolute"} or \code{"ppm"}. Should the tolerance be an absolute value or in ppm?}

\item{show_progress}{A \code{logical} indicating whether the progress of the filtering should be printed to the console. Only important for large tibbles.}
}
\value{
A filtered tibble.
}
\description{
Filters Features based on the presence of MSn fragments. This can help, for example with the identification of potential homologous molecules.
}
\examples{
# all of the given fragments (3) must be found
# returns the first row of toy_mgf
toy_mgf \%>\%
  filter_msn(fragments = c(12.3456, 23.4567, 34.5678), min_found = 3)

# all of the given fragments (3) must be found
# returns an empty tibble because the third fragment
# of row 1 (34.5678)
# is outside of the tolerance (5 ppm):
# Lower bound:
# 34.5688 - 34.5688 * 5 / 1000000 = 34.5686
# Upper bound:
# 34.5688 + 34.5688 * 5 / 1000000 = 34.5690
toy_mgf \%>\%
  filter_msn(fragments = c(12.3456, 23.4567, 34.5688), min_found = 3)

# only 2 of the 3 fragments must be found
# returns the first row of toy_mgf
toy_mgf \%>\%
  filter_msn(fragments = c(12.3456, 23.4567, 34.5688), min_found = 2)
}
