% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apple.R
\name{meta_apple_web_app}
\alias{meta_apple_web_app}
\title{Apple Web App Meta Tags}
\usage{
meta_apple_web_app(
  .meta = meta(),
  title = NULL,
  capable = NULL,
  status_bar_style = c("default", "black", "black-translucent")
)
}
\arguments{
\item{.meta}{A \code{meta} object created by \code{\link[=meta]{meta()}} or \code{\link[=as_meta]{as_meta()}}, or returned
by a \verb{meta_*()} object.}

\item{title}{Launch Icon Title}

\item{capable}{Enables standalone (full-screen) mode if TRUE}

\item{status_bar_style}{Status bar appearance. has no effect unless
standalone more is enabled (see \code{capable}).

"If content is set to default, the status bar appears normal. If set to
black, the status bar has a black background. If set to black-translucent,
the status bar is black and translucent. If set to default or black, the
web content is displayed below the status bar. If set to black-translucent,
the web content is displayed on the entire screen, partially obscured by
the status bar. The default value is default."}
}
\value{
A \code{meta} object, or a set of \verb{<meta>} HTML tags inside an HTML
\verb{<head>} tag. For use in \code{\link[rmarkdown:html_document]{rmarkdown::html_document()}}, \code{\link[shiny:runApp]{shiny::runApp()}},
or other HTML locations.
}
\description{
Apple Web App Meta Tags
}
\examples{
meta() \%>\%
  meta_apple_web_app(
    title = "My Fancy App",
    capable = TRUE,
    status_bar_style = "black-translucent"
  )
}
\references{
\url{https://developer.apple.com/library/archive/documentation/AppleApplications/Reference/SafariHTMLRef/Articles/MetaTags.html}
}
\seealso{
Other meta: 
\code{\link{meta_apple_itunes_app}()},
\code{\link{meta_general}()},
\code{\link{meta_geo}()},
\code{\link{meta_google_scholar}()},
\code{\link{meta_name}()},
\code{\link{meta_social}()},
\code{\link{meta_tag}()},
\code{\link{meta_viewport}()},
\code{\link{meta}()}
}
\concept{meta}
