% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelists.R
\name{convert_var_to_fct}
\alias{convert_var_to_fct}
\title{Convert Variable to Factor with Levels Set by Control Terms}
\usage{
convert_var_to_fct(data, metacore, var)
}
\arguments{
\item{data}{A dataset containing the variable to be modified}

\item{metacore}{A metacore object to get the codelist from. If the
variable has different codelists for different datasets the metacore object
will need to be subsetted using \code{select_dataset} from the metacore package}

\item{var}{Name of variable to change}
}
\value{
Dataset with variable changed to a factor
}
\description{
This functions takes a dataset, a metacore object and a variable name. Then
looks at the metacore object for the control terms for the given variable and
uses that to convert the variable to a factor with those levels. If the
control terminology is a code list, the code column will be used. The
function fails if the control terminology is an external library
}
\examples{
library(metacore)
library(haven)
library(dplyr)
load(metacore_example("pilot_ADaM.rda"))
spec <- metacore \%>\% select_dataset("ADSL")
dm <- read_xpt(metatools_example("dm.xpt")) \%>\%
  select(USUBJID, SEX, ARM)
# Variable with codelist control terms
convert_var_to_fct(dm, spec, SEX)
# Variable with permitted value control terms
convert_var_to_fct(dm, spec, ARM)
}
