% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validators.R
\name{discr.validator}
\alias{discr.validator}
\title{Discriminability Utility Validator}
\usage{
discr.validator(
  X,
  Y,
  is.dist = FALSE,
  dist.xfm = mgc.distance,
  dist.params = list(method = "euclidean"),
  dist.return = NULL,
  remove.isolates = TRUE
)
}
\arguments{
\item{X}{is interpreted as:
\describe{
   \item{a \code{[n x d]} data matrix}{X is a data matrix with \code{n} samples in \code{d} dimensions, if flag \code{is.dist=FALSE}.}
   \item{a \code{[n x n]} distance matrix}{X is a distance matrix. Use flag \code{is.dist=TRUE}.}
}}

\item{Y}{is interpreted as:
\describe{
   \item{a \code{[n x d]} data matrix}{Y is a data matrix with \code{n} samples in \code{d} dimensions, if flag \code{is.dist=FALSE}.}
   \item{a \code{[n x n]} distance matrix}{Y is a distance matrix. Use flag \code{is.dist=TRUE}.}
}}

\item{is.dist}{a boolean indicating whether your \code{X} input is a distance matrix or not. Defaults to \code{FALSE}.}

\item{dist.xfm}{if \code{is.dist == FALSE}, a distance function to transform \code{X}. If a distance function is passed,
it should accept an \code{[n x d]} matrix of \code{n} samples in \code{d} dimensions and return a \code{[n x n]} distance matrix
as the \code{$D} return argument. See \link[mgc]{mgc.distance} for details.}

\item{dist.params}{a list of trailing arguments to pass to the distance function specified in \code{dist.xfm}.
Defaults to \code{list(method='euclidean')}.}

\item{dist.return}{the return argument for the specified \code{dist.xfm} containing the distance matrix. Defaults to \code{FALSE}.
\describe{
    \item{\code{is.null(dist.return)}}{use the return argument directly from \code{dist.xfm} as the distance matrix. Should be a \code{[n x n]} matrix.}
    \item{\code{is.character(dist.return) | is.integer(dist.return)}}{use \code{dist.xfm[[dist.return]]} as the distance matrix. Should be a \code{[n x n]} matrix.}
}}

\item{remove.isolates}{whether to remove isolated samples, or samples with only a single instance in the \code{Y} vector.}
}
\value{
A list containing the following:
\item{\code{DX}}{The X distance matrix, as a \code{[n x n]} matrix.}
\item{\code{Y}}{The sample ids, with isolates removed.}
}
\description{
A script that validates that data inputs are correct, and returns a distance matrix and a ids vector.
}
\keyword{internal}
