% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_rm.R
\name{mc_rm}
\alias{mc_rm}
\title{Remove files or directories}
\usage{
mc_rm(target, recursive = FALSE, flags = "", verbose = FALSE)
}
\arguments{
\item{target}{Character string specifying the target file or
directory path to be removed.}

\item{recursive}{Logical indicating whether to recursively remove
directories. Default is \code{FALSE}.}

\item{flags}{Additional flags to be passed to the \code{rm} command.
Default is an empty string.}

\item{verbose}{Logical indicating whether to list files removed.
Default is \code{FALSE}.}
}
\value{
Returns the list from \code{\link[processx:run]{processx::run()}}, with components \code{status},
\code{stdout}, \code{stderr}, and \code{timeout}; invisibly.
}
\description{
This function uses the \code{mc} command to remove files or directories
at the specified target location.
}
\details{
see \code{mc("rm -h")} for details.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Remove a file
mc_rm("path/to/file.txt")

# Remove a directory recursively
mc_rm("path/to/directory", recursive = TRUE)
\dontshow{\}) # examplesIf}
}
