% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf-stream.R
\name{pdf_text}
\alias{pdf_text}
\title{Add text to a PDF doc}
\usage{
pdf_text(
  doc,
  text,
  x,
  y,
  fontfamily = "Helvetica",
  fontface = "plain",
  fontsize = 12,
  mode = 0,
  ...,
  gp = pgpar(),
  tf = NULL,
  clip = NULL
)
}
\arguments{
\item{doc}{A \code{pdf_doc} object created by \code{\link{create_pdf}()}}

\item{text}{string}

\item{x, y}{position (Length = 1 or N)}

\item{fontfamily}{Font name. Default: 'Helvetica'. One of: "Helvetica", 
"Courier", "Times", "Symbol", "ZapfDingbats".  'sans', 'mono' and
'serif' also accepted for 'Helvetica', 'Courier' and 'Times', 
respectively. (Length = 1)}

\item{fontface}{Font styling. Default: 'plain'. One of: 'plain', 'bold', 
'italic', 'bold.italic' (Length = 1)}

\item{fontsize}{Default: 12 (Length = 1)}

\item{mode}{Default: 0 (Length = 1)
\itemize{
  \item{0 - Fill text. Normal. Default}
  \item{1 - Stroke text}
  \item{2 - Fill then stroke}
  \item{3 - NO fill or stroke. Invisible}
  \item{4 - Fill text and add to path for clipping}
  \item{5 - Stroke text and add to path for clipping}
  \item{6 - Fill, then stroke text and add to path for clipping}
  \item{7 - Add text to path for clipping}
}}

\item{...}{further arguments to be added to \code{gp}}

\item{gp}{A named list \code{gp} object created by \code{\link{pgpar}()}}

\item{tf}{either a single transform (\code{tf_translate()}, \code{tf_scale()},
\code{tf_rotate()}), or a list of these transforms.  Default: NULL,
no local transformation applied (global transformations still apply)}

\item{clip}{either a single clip (\code{clip_rect()}, \code{clip_polygon()}),
or a list of these clips.  Default: NULL,
no local clipping applied (global clipping still applicable)}
}
\value{
\code{pdf_doc}
}
\description{
Add text to a PDF doc
}
\examples{
doc <- create_pdf() |>
   pdf_text("Hello", x = 20, y = 20, fontsize = 50)
}
\seealso{
Other object creation functions: 
\code{\link{pdf_bezier}()},
\code{\link{pdf_circle}()},
\code{\link{pdf_image}()},
\code{\link{pdf_line}()},
\code{\link{pdf_polygon}()},
\code{\link{pdf_polyline}()},
\code{\link{pdf_rect}()}
}
\concept{object creation functions}
