% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faggregate.R
\name{faggregate}
\alias{faggregate}
\title{Fast Aggregation of ResampleResults and BenchmarkResults}
\usage{
faggregate(obj, measure, conditions = FALSE)
}
\arguments{
\item{obj}{(\link[mlr3:ResampleResult]{mlr3::ResampleResult} | \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}).}

\item{measure}{(\link[mlr3:Measure]{mlr3::Measure}).}

\item{conditions}{(\code{logical(1)})\cr
If \code{TRUE}, the function returns the number of warnings and the number of errors.}
}
\value{
(\code{\link[data.table:data.table]{data.table::data.table()}})
}
\description{
Aggregates a \link[mlr3:ResampleResult]{mlr3::ResampleResult} or \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult} for a single simple measure.
Returns the aggregated score for each resample result.
}
\details{
This function is faster than \verb{$aggregate()} because it does not reassemble the resampling results.
It only works on simple measures which do not require the task, learner, model or train set to be available.
}
