% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_callbacks.R
\name{mlr3tuning.backup}
\alias{mlr3tuning.backup}
\title{Backup Benchmark Result Callback}
\description{
This \link[mlr3misc:Callback]{mlr3misc::Callback} writes the \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult} after each batch to disk.
}
\examples{
clbk("mlr3tuning.backup", path = "backup.rds")

# tune classification tree on the pima data set
instance = tune(
  tuner = tnr("random_search", batch_size = 2),
  task = tsk("pima"),
  learner = lrn("classif.rpart", cp = to_tune(1e-04, 1e-1, logscale = TRUE)),
  resampling = rsmp("cv", folds = 3),
  measures = msr("classif.ce"),
  term_evals = 4,
  callbacks = clbk("mlr3tuning.backup", path = tempfile(fileext = ".rds"))
)
}
