% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rsolo.R
\name{checkFiles}
\alias{checkFiles}
\alias{Rsolo}
\title{Checks whether all specified files are valid R or Python files}
\usage{
checkFiles(
  files,
  index = seq_along(files),
  path = NULL,
  open = openFile,
  mode = c("parse", "run", "exist"),
  ...
)

Rsolo(
  files,
  index = seq_along(files),
  path = NULL,
  open = openFile,
  mode = c("parse", "run", "exist"),
  ...
)
}
\arguments{
\item{files}{character: file name(s)}

\item{index}{integer(s):  if \code{length(index)==1} the files from \code{index} to \code{length(files)} are checked (default: \code{seq_along(files)}) otherwise the files with values in \code{index} are checked.}

\item{path}{character: path to start from (default: \code{getwd()})}

\item{open}{function: function or function name to call after an error occurs (default: \code{openFile})}

\item{mode}{character which check to do}

\item{...}{further parameters given to the function in \code{open}}
}
\value{
nothing
}
\description{
\code{checkFiles} checks whether all specified files are valid source files that can be executed
independently of each other. If an error occurs then:
\enumerate{
\item If \code{open} is a function name or a function with a \code{file} parameter, then \code{checkFiles} will try to open the faulty source file, otherwise not.
\item The execution of \code{checkFiles} is stopped.
}

If you do not want the faulty source file to be opened immediately, use \code{open=0}.

Three modes are available for checking a \code{file}:
\enumerate{
\item \code{exist}: Does the source file exist?
\item \code{parse}: (default) is \code{parse(file)} or \verb{python -m "file"} successful?
\item \code{run}: is \verb{Rscript "file"} or \verb{python "file"} successful?
}

If source files has side effects, e.g. generating an image or some other output, and \code{mode=="parse"} then
this will done during the check.
}
\examples{
if (interactive()) {
  files <- list.files(pattern="*.(R|py)$", full.names=TRUE, recursive=TRUE)
  checkFiles(files)
}
}
