% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverse_transformation_variables.R
\name{Inverse_transformation_variables}
\alias{Inverse_transformation_variables}
\title{Inverse transform variables}
\usage{
Inverse_transformation_variables(
  data,
  df_sim,
  variables,
  bin_variables,
  categ_variables,
  count_variables,
  n_samples,
  generalized_mode,
  generalized_mode_lmbds
)
}
\arguments{
\item{data}{a data frame with original variables.}

\item{df_sim}{data frame with transformed variables.}

\item{variables}{variables a character vector indicating which
columns of \code{data} should be used.}

\item{bin_variables}{a character vector listing the binary variables.}

\item{categ_variables}{a character vector listing the ordinal categorical
variables.}

\item{count_variables}{a character vector listing the count as a sub
sub category of categorical variables. Count variables should be part
of categorical variables vector. Count variables are treated differently
when using gldex to simulate them.}

\item{n_samples}{Number of rows of each simulated data set. Default is
the number of rows of \code{data}.}

\item{generalized_mode}{A logical value indicating if 
generalized lambda/poisson distributions or set up thresholds will be used to
generate the simulated values}

\item{generalized_mode_lmbds}{A matrix that contains lambdas values for each 
of the variables of the data set to be used for either Generalized Lambda
Distribution Generalized Poisson Distribution or setting up thresholds}
}
\value{
A data frame with all inverse transformed values.
}
\description{
This function is used internally by \code{\link[modgo]{modgo}}. It transforms
all variables to their original scale.
}
\author{
Francisco M. Ojeda, George Koliopanos
}
\keyword{Normal}
\keyword{rank}
\keyword{transformation}
