#' @name cadmium1
#'
#' @title Reproduction and survival data sets of chronic laboratory toxicity
#' tests of cadmium with Daphnia
#'
#' @description
#' - **cadmium1**: Reproduction and survival data sets of chronic laboratory toxicity tests with
#' \emph{Daphnia magna} freshwater invertebrate exposed to five concentrations
#' of cadmium during 21 days. Five concentrations were
#' tested, with four replicates per concentration. Each replicate contained 10
#' organisms. Reproduction and survival were monitored at 10 time points.
#'
#' @references
#' Billoir, E., Delhaye, H., Forfait, C., Clement, B.,
#' Triffault-Bouchet, G., Charles, S. and Delignette-Muller, M.L. (2012)
#' Comparison of toxicity tests with different exposure time patterns: The added
#' value of dynamic modelling in predictive ecotoxicology, \emph{Ecotoxicology
#' and Environmental Safety}, 75, 80-86.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(cadmium1)
#'
NULL

#' @name cadmium2
#'
#' @title Reproduction and survival data sets of chronic laboratory toxicity
#' tests of cadmium with snails
#'
#' @description
#' - **cadmium2**: Reproduction and survival data sets of chronic laboratory toxicity tests with
#' snails (\emph{Lymnaea stagnalis}) exposed to six concentrations of cadmium
#' during 28 days. Six concentrations were tested, with six replicates per
#' concentration. Each replicate contained five organisms. Reproduction and
#' survival were monitored at 17 time points.
#'
#' @references
#' Ducrot, V., Askem, C., Azam, D., Brettschneider, D., Brown,
#' R., Charles, S., Coke, M., Collinet, M., Delignette-Muller, M.L.,
#' Forfait-Dubuc, C., Holbech, H., Hutchinson, T., Jach, A., Kinnberg, K.L.,
#' Lacoste, C., Le Page, G., Matthiessen, P., Oehlmann, J., Rice, L.,
#' Roberts, E., Ruppert, K., Davis, J.E., Veauvy, C., Weltje, L., Wortham, R.
#' and Lagadic, L. (2014)
#' Development and validation of an OECD reproductive toxicity test guideline with
#' the pond snail Lymnaea stagnalis (Mollusca, Gastropoda),
#' \emph{Regulatory Toxicology and Pharmacology}, 70(3), 605-14.
#'
#' Charles, S., Ducrot, V., Azam, D., Benstead, R., Brettschneider, D., De Schamphelaere, K.,
#' Filipe Goncalves, S., Green, J.W., Holbech, H., Hutchinson, T.H., Faber, D., Laranjeiro, F.,
#' Matthiessen, P., Norrgren, L., Oehlmann, J., Reategui-Zirena, E., Seeland-Fremer, A., Teigeler, M.,
#' Thome, J.P., Tobor Kaplon, M., Weltje, L., Lagadic, L. (2016)
#' Optimizing the design of a reproduction toxicity test with the pond snail Lymnaea stagnalis,
#' \emph{Regulatory Toxicology and Pharmacology}, vol. 81 pp.47-56.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(cadmium2)
#'
NULL


#' @name chlordan
#'
#' @title Reproduction and survival data sets of chronic laboratory toxicity
#'  tests of chlordan with Daphnia
#'
#' @description
#' - **chlordan**: Reproduction and survival data sets of chronic laboratory toxicity tests with
#' \emph{Daphnia magna} freshwater invertebrate exposed to six concentrations
#' of one organochlorine insecticide (chlordan) during 21 days. Six concentrations were
#' tested, with 10 replicates per concentration. Each replicate contained one
#' organism. Reproduction and survival were monitored at 22 time points.
#' See Manar et al. (2009).
#'
#' @references
#' Manar, R., Bessi, H. and Vasseur, P. (2009) Reproductive effects
#' and bioaccumulation of chlordan in Daphnia magna, \emph{Environmental
#' Toxicology and Chemistry}, 28(10), 2150-2159.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(chlordan)
#'
NULL


#' @name copper
#'
#' @title Reproduction and survival data sets of chronic laboratory toxicity
#' tests of copper on Daphnia
#'
#' @description
#' - **copper**: Reproduction and survival data sets of chronic laboratory toxicity tests with
#' \emph{Daphnia magna} freshwater invertebrate exposed to five concentrations
#' of copper during 21 days. Five concentrations were
#' tested, with three replicates per concentration. Each replicate contained 20
#' organisms. Reproduction and survival were monitored at 16 time points.
#'
#' @references Billoir, E., Delignette-Muller, M.L., Pery, A.R.R. and
#' Charles, S. (2008) A Bayesian Approach to Analyzing Ecotoxicological Data,
#' \emph{Environmental Science & Technology}, 42 (23), 8978-8984.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(copper)
#'
NULL

#' @name dichromate
#'
#' @title Survival data set of chronic laboratory toxicity tests of dichromate
#' with Daphnia
#'
#' @description
#' - **dichromate**: Survival data set of chronic laboratory toxicity tests with
#' \emph{Daphnia magna} freshwater invertebrate exposed to six concentrations
#' of one oxidizing agent (potassium dichromate) during 21 days. Six
#' concentrations were tested with one replicate of 50 organisms per concentration.
#' Survival is monitored at 10 time points.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @references Bedaux, J., Kooijman, SALM (1994) Statistical analysis of toxicity tests,
#' based on hazard modeling, \emph{Environmental and Ecological Statistics}, 1,
#' 303-314.
#'
#' @usage
#' data(dichromate)
#'
NULL

#' @name propiconazole
#'
#' @title Survival data set of chronic laboratory toxicity tests of propiconazole
#' with Gammarus pulex
#'
#' @description
#' - **propiconazole**: Survival data set of chronic laboratory toxicity tests with
#' \emph{Gammarus pulex} freshwater invertebrate exposed to eight concentrations
#' of one fungicide (propiconazole) during four days. Eight
#' concentrations were tested with two replicates of 10 organisms per concentration.
#' Survival is monitored at five time points.
#'
#' @references Nyman, A.-M., Schirmer, K., Ashauer, R., (2012) Toxicokinetic-toxicodynamic
#' modelling of survival of \emph{Gammarus pulex} in multiple pulse exposures to
#' propiconazole: model assumptions, calibration data requirements and predictive
#' power, \emph{Ecotoxicology}, (21), 1828-1840.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(propiconazole)
#'
#'
NULL


#' @name zinc
#'
#' @title Reproduction and survival data sets of a chronic laboratory toxicity
#'  tests of zinc with Daphnia
#'
#' @description
#' - **zinc**: Reproduction and survival data sets of a chronic laboratory toxicity tests with
#' \emph{Daphnia magna} freshwater invertebrate exposed to four concentrations
#' of zinc during 21 days. Four concentrations were
#' tested with three replicates per concentration. Each replicate contained 20
#' organisms. Reproduction and survival were monitored at 15 time points.
#'
#' @references Billoir, E., Delignette-Muller, M.L., Pery, A.R.R. and
#' Charles, S. (2008) A Bayesian Approach to Analyzing Ecotoxicological Data,
#' \emph{Environmental Science & Technology}, 42 (23), 8978-8984.
#'
#' @docType data
#'
#' @keywords datasets
#'
#'
#' @usage
#' data(zinc)
#'
NULL


#' @name cadmium_daphnia
#'
#' @title Continuous response of toxicity test of cadmium on Daphnia
#'
#' @description
#' - **cadmium_daphnia**: Exposure of *Daphnia magna* to cadmium (5
#' concentrations including the
#'  control) during 21 days. 10
#'  time-points and 4 replicates of 10 animals. Length
#'  data is collected (expressed in mm).
#'
#'  @references Billoir, E., Delignette-Muller, M.L., Pery, A.R.R. and
#' Charles, S. (2008) A Bayesian Approach to Analyzing Ecotoxicological Data,
#' \emph{Environmental Science & Technology}, 42 (23), 8978-8984.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(cadmium_daphnia)
#'
NULL

#' @name chlordan_daphnia
#'
#' @title Continuous response of toxicity test of chlordan on Daphnia
#'
#' @description
#' - **chlordan_daphnia**: Exposure of Daphnia magna to chlordan (6 concentrations including the
#' control) at day 21. Length data is collected
#'  (expressed in mm).
#'  See Manar et al. (2009)
#'
#'  @references Manar, R., Bessi, H. and Vasseur, P. (2009) Reproductive effects
#' and bioaccumulation of chlordan in Daphnia magna, \emph{Environmental
#' Toxicology and Chemistry}, 28(10), 2150-2159.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(chlordan_daphnia)
#'
NULL


#' @name copper_daphnia
#'
#' @title Continuous response of toxicity test of copper on Daphnia
#'
#' @description
#' - **copper_daphnia**: Exposure of Daphnia magna to copper (5 concentrations including the control)
#' during 21 days. 16 time-points and 3 replicates of
#'  20 animals. Length data is collected (expressed in mm).
#'
#' @references Billoir, E., Delignette-Muller, M.L., Pery, A.R.R. and
#' Charles, S. (2008) A Bayesian Approach to Analyzing Ecotoxicological Data,
#' \emph{Environmental Science & Technology}, 42 (23), 8978-8984.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(copper_daphnia)
#'
NULL

#' @name zinc_daphnia
#'
#' @title Continuous response of toxicity test of zinc on Daphnia
#'
#' @description
#' - **zinc_daphnia**: Exposure of Daphnia magna to zinc
#' (4 concentrations including the control)
#'  during 21 days. 15 time-points and 3 replicates of 20
#' animals. Length data is collected (expressed in mm).
#'
#' @references Billoir, E., Delignette-Muller, M.L., Pery, A.R.R. and
#' Charles, S. (2008) A Bayesian Approach to Analyzing Ecotoxicological Data,
#' \emph{Environmental Science & Technology}, 42 (23), 8978-8984.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(zinc_daphnia)
#'
NULL

#' @name subst01_lymnaea
#'
#' @title Continuous response of toxicity test on snails
#'
#' @description
#' - **subst01_lymnaea**: Exposure of snails to a given substance (6 concentrations including the
#'  control) at day 56. Length of shell is collected
#'  (expressed in mm).
#'
#'  @references Ducrot, V., Askem, C., Azam, D., Brettschneider, D., Brown,
#' R., Charles, S., Coke, M., Collinet, M., Delignette-Muller, M.L.,
#' Forfait-Dubuc, C., Holbech, H., Hutchinson, T., Jach, A., Kinnberg, K.L.,
#' Lacoste, C., Le Page, G., Matthiessen, P., Oehlmann, J., Rice, L.,
#' Roberts, E., Ruppert, K., Davis, J.E., Veauvy, C., Weltje, L., Wortham, R.
#' and Lagadic, L. (2014)
#' Development and validation of an OECD reproductive toxicity test guideline with
#' the pond snail Lymnaea stagnalis (Mollusca, Gastropoda),
#' \emph{Regulatory Toxicology and Pharmacology}, 70(3), 605-14.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(subst01_lymnaea)
NULL


#' @name plant01
#'
#' @title Continuous response of toxicity test on plants
#'
#' @description
#' - **plant**: Plant species exposed to a given product during 21 days for the
#' vegetative vigour test. Shoot dry weight data is collected
#'
#' @references Charles, S., Wu, D., Ducrot, V. (2021). How to account for
#'  the uncertainty from standard toxicity tests in species sensitivity
#'  distributions: An example in non-target plants. \emph{PLOS ONE}
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(plant01)
NULL

#' @name plant02
#'
#' @title Continuous response of toxicity test on plants
#'
#' @description
#' - **plant**: Plant species exposed to a given product during 21 days for the
#' vegetative vigour test. Shoot dry weight data is collected
#'
#' @references Charles, S., Wu, D., Ducrot, V. (2021). How to account for
#'  the uncertainty from standard toxicity tests in species sensitivity
#'  distributions: An example in non-target plants. \emph{PLOS ONE}
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(plant02)
NULL

#' @name plant03
#'
#' @title Continuous response of toxicity test on plants
#'
#' @description
#' - **plant**: Plant species exposed to a given product during 21 days for the
#' vegetative vigour test. Shoot dry weight data is collected
#'
#' @references Charles, S., Wu, D., Ducrot, V. (2021). How to account for
#'  the uncertainty from standard toxicity tests in species sensitivity
#'  distributions: An example in non-target plants. \emph{PLOS ONE}
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(plant03)
NULL

#' @name plant04
#'
#' @title Continuous response of toxicity test on plants
#'
#' @description
#' - **plant**: Plant species exposed to a given product during 21 days for the
#' vegetative vigour test. Shoot dry weight data is collected
#'
#' @references Charles, S., Wu, D., Ducrot, V. (2021). How to account for
#'  the uncertainty from standard toxicity tests in species sensitivity
#'  distributions: An example in non-target plants. \emph{PLOS ONE}
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(plant04)
NULL

#' @name plant05
#'
#' @title Continuous response of toxicity test on plants
#'
#' @description
#' - **plant**: Plant species exposed to a given product during 21 days for the
#' vegetative vigour test. Shoot dry weight data is collected
#'
#' @references Charles, S., Wu, D., Ducrot, V. (2021). How to account for
#'  the uncertainty from standard toxicity tests in species sensitivity
#'  distributions: An example in non-target plants. \emph{PLOS ONE}
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(plant05)
NULL

#' @name plant06
#'
#' @title Continuous response of toxicity test on plants
#'
#' @description
#' - **plant**: Plant species exposed to a given product during 21 days for the
#' vegetative vigour test. Shoot dry weight data is collected
#'
#' @references Charles, S., Wu, D., Ducrot, V. (2021). How to account for
#'  the uncertainty from standard toxicity tests in species sensitivity
#'  distributions: An example in non-target plants. \emph{PLOS ONE}
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(plant06)
NULL

#' @name plant07
#'
#' @title Continuous response of toxicity test on plants
#'
#' @description
#' - **plant**: Plant species exposed to a given product during 21 days for the
#' vegetative vigour test. Shoot dry weight data is collected
#'
#' @references Charles, S., Wu, D., Ducrot, V. (2021). How to account for
#'  the uncertainty from standard toxicity tests in species sensitivity
#'  distributions: An example in non-target plants. \emph{PLOS ONE}
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(plant07)
NULL

#' @name plant08
#'
#' @title Continuous response of toxicity test on plants
#'
#' @description
#' - **plant**: Plant species exposed to a given product during 21 days for the
#' vegetative vigour test. Shoot dry weight data is collected
#'
#' @references Charles, S., Wu, D., Ducrot, V. (2021). How to account for
#'  the uncertainty from standard toxicity tests in species sensitivity
#'  distributions: An example in non-target plants. \emph{PLOS ONE}
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(plant08)
NULL

#' @name plant09
#'
#' @title Continuous response of toxicity test on plants
#'
#' @description
#' - **plant**: Plant species exposed to a given product during 21 days for the
#' vegetative vigour test. Shoot dry weight data is collected
#'
#' @references Charles, S., Wu, D., Ducrot, V. (2021). How to account for
#'  the uncertainty from standard toxicity tests in species sensitivity
#'  distributions: An example in non-target plants. \emph{PLOS ONE}
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(plant09)
NULL

#' @name plant10
#'
#' @title Continuous response of toxicity test on plants
#'
#' @description
#' - **plant**: Plant species exposed to a given product during 21 days for the
#' vegetative vigour test. Shoot dry weight data is collected
#'
#' @references Charles, S., Wu, D., Ducrot, V. (2021). How to account for
#'  the uncertainty from standard toxicity tests in species sensitivity
#'  distributions: An example in non-target plants. \emph{PLOS ONE}
#'
#' @docType data
#' @keywords datasets
#' @usage
#' data(plant10)
NULL

#' @name reco27
#'
#' @title Continuous response of toxicity test
#'
#' @description
#' Additional dataset for continuous data
#'
#' @docType data
#' @keywords datasets
#' @usage
#' data(reco27)
NULL
