% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrfrequentist.R
\name{mrfrequentist}
\alias{mrfrequentist}
\title{Fitting frequentist linear models using Merge and Reduce}
\usage{
mrfrequentist(
  formula,
  fileMr = NULL,
  dataMr = NULL,
  obsPerBlock,
  approach = c("1", "3"),
  sep = "auto",
  dec = ".",
  header = TRUE,
  naStrings = "NA",
  colNames = NULL,
  naAction = na.fail
)
}
\arguments{
\item{formula}{\code{(formula)} \cr
See \code{\link[stats]{formula}}. Note that \code{mrfrequentist} currently
supports numeric predictors only.}

\item{fileMr}{(\code{character}) \cr The name of a file, including the
filepath, to be read in blockwise. Either \code{fileMr} or \code{dataMr}
needs to be specified. When using this argument, the arguments \code{sep}, 
\code{dec}, \code{header}, \code{naStrings}, \code{colNames} (as in \code{\link[data.table]{fread}}) 
are of relevance. Further options from \code{fread} are currently not supported.
Also note that defaults might differ. In case the data to be read in has row names,
note that these will be read in as regular column. This may need
special treatment.}

\item{dataMr}{(\code{data.frame}) \cr The data to be used for the regression
analysis. Either \code{fileMr} or \code{dataMr} needs to be specified.
Note that the arguments \code{sep}, \code{dec}, \code{header}, \code{naStrings}, 
and \code{colNames} are ignored when \code{dataMr} is specified.}

\item{obsPerBlock}{\code{(numeric)} \cr Value specifying the number of
observations in each block. This number has to be larger than the number of 
regression coefficients. Moreover, for approach 1 the recommended ratio of 
observations per regression coefficient is larger than 25 (Geppert et al., 2020). 
Note that the last block may contain less observations than specified 
depending on the sample size. If the number of observations in this last 
block is too small it is not included in the model and a warning is 
issued.}

\item{approach}{\code{(character)} \cr Approach specifying the merge
technique. One of either "1" or "3". Approach "1" is based on a weighted
mean procedure whereas approach "3" is an exact method based on blockwise 
calculations of X'X, y'X and y'y. See Geppert et al. (2020) for details on 
the approaches and section Details below for comments on approach "3".}

\item{sep}{See documentation of \code{\link[data.table]{fread}}. Default is
"auto". Ignored when \code{dataMr} is specified.}

\item{dec}{See documentation of \code{\link[data.table]{fread}}. Default is 
".". Ignored when \code{dataMr} is specified.}

\item{header}{\code{(logical)} \cr See documentation of
\code{\link[data.table]{fread}}. Defaults to \code{TRUE}. Ignored when
\code{dataMr} is specified. If \code{header} is set to \code{FALSE} and no 
\code{colNames} are given, then column names default to "V" followed by the 
column number.}

\item{naStrings}{\code{(character)} \cr Optional argument.
See argument na.strings of \code{\link[data.table]{fread}}.
Default is "NA". Ignored when \code{dataMr} is specified and optional
when \code{fileMr} is used.}

\item{colNames}{\code{(character vector)} \cr Same as argument
col.names of \code{\link[data.table]{fread}}. Ignored when \code{dataMr} is
specified and optional when \code{fileMr} is used.}

\item{naAction}{\code{(function)} \cr Action to be taken when missing values
are present in the data. Currently only \code{\link[stats]{na.fail}} is 
supported.}
}
\value{
Returns an object of class \code{"mrfrequentist"} which is a list
  containing the following components \strong{for both approaches "1" and "3":}
  \item{approach}{The approach used for merging the models. Either "1" or "3".}
  \item{formula}{The model's \code{formula}.}
  \item{level}{Number of level of the final model in Merge and Reduce. This is equal
    to \eqn{\lceil \log_2{(\code{numberObs}/\code{obsPerBlock})} \rceil + 1}{
    log2(ceiling(numberObs/obsPerBlock))+1} 
    and corresponds to the number of buckets in Figure 1 of Geppert et al. (2020).} 
  \item{numberObs}{The total number of observations.}
  \item{summaryStats}{Summary statistics reporting the estimated regression coefficients 
  and their unbiased standard errors. Estimates are based
  on the merge technique as specified in the argument \code{approach}.
  For approach "1" the estimates of the standard errors are corrected
  dividing by \eqn{ \sqrt \lceil \code{numberObs /  obsPerBlock} \rceil
  }{sqrt(ceiling(numberObs/obsPerBlock))}. For further details see Geppert et al. (2020).
  For approach "3" the unbiased estimates of the standard errors are given.}
  \item{dataHead}{First six rows of the data in the first block. This serves
  as a sanity check, especially when using the argument \code{fileMr}.}
  \item{terms}{Terms object.}
  \strong{Additionally for approach "3" only:}
  \item{XTX}{The final model's \code{crossprod(X, X)}.}
  \item{yTX}{The final model's \code{crossprod(y, X)}.}
  \item{yTy}{The final model's \code{crossprod(y, y)}.}
}
\description{
\code{mrfrequentist} is used to conduct frequentist linear
  regression on very large data sets using Merge and Reduce as
  described in Geppert et al. (2020).
}
\section{Details}{

  In approach "3" the estimated regression coefficients and their unbiased standard errors
  are calculated via qr decompositions on X'X (as in \code{\link[speedglm]{speedlm}} 
  with argument \code{method = "qr"}). Moreover, the merge step uses the same 
  idea of blockwise addition for X'X, y'y and y'X as \code{speedglm}'s updating 
  procedure \code{\link[speedglm]{updateWithMoreData}}. Conceptually though, 
  Merge and Reduce is not an updating algorithm as it merges models based on 
  a comparable amount of data along a tree structure to obtain a final model.
}

\examples{
## run mrfrequentist() with dataMr
data(exampleData)
fit1 = mrfrequentist(dataMr = exampleData, approach = "1", obsPerBlock = 300,
formula = V11 ~ .)

## run mrfrequentist() with fileMr
filepath = system.file("extdata", "exampleFile.txt", package = "mrregression")
fit2 = mrfrequentist(fileMr = filepath, approach = "3", header = TRUE,
obsPerBlock = 100, formula = y ~ .)
}
\references{
Geppert, L.N., Ickstadt, K., Munteanu, A., & Sohler, C. (2020).
  Streaming statistical models via Merge & Reduce. International Journal
  of Data Science and Analytics, 1-17, \cr
  doi: https://doi.org/10.1007/s41060-020-00226-0
}
