% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_degree_seq.R
\name{get_degree_seq}
\alias{get_degree_seq}
\title{Degree sequence of a multigraph}
\usage{
get_degree_seq(adj, type = "multigraph")
}
\arguments{
\item{adj}{matrix of integers representing graph adjacency matrix.}

\item{type}{equals \code{'graph'} if adjacency matrix is for graphs (default),
equals \code{'multigraph'} if it is the equivalence of the adjacency matrix for multigraphs
(with matrix diagonal representing edge loops double counted).}
}
\value{
Vector of integers representing the degree sequence of a (multi)graph.
}
\description{
Finds the degree sequence of the adjacency matrix of an observed graph or multigraph
}
\details{
Gives the degree sequence of the adjacency matrix of an observed graph or multigraph.
Note that the matrix diagonal should be even if the matrix represents a multigraph.
}
\examples{
 # Adjacency matrix for undirected network with 3 nodes
 A <-  matrix(c(0, 1, 2,
                1, 2, 1,
                2, 1, 2), nrow=3, ncol=3)

 # If A represents a graph
 get_degree_seq(adj = A, type = 'graph')

 # If A represents a multigraph
 get_degree_seq(adj = A, type = 'multigraph')
}
\references{
Shafie, T. (2015). A Multigraph Approach to Social Network Analysis. \emph{Journal of Social Structure}, 16.
\cr

Shafie, T. (2016). Analyzing Local and Global Properties of Multigraphs. \emph{The Journal of Mathematical Sociology}, 40(4), 239-264.
\cr

#' Shafie, T., Schoch, D. (2021). Multiplexity analysis of networks using multigraph representations.
\emph{Statistical Methods & Applications} 30, 1425–1444.
}
\author{
Termeh Shafie
}
