% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estparmtd.R
\name{estparmtd}
\alias{estparmtd}
\title{Estimation of the Parameters of a Multivariate \eqn{t} Distribution}
\usage{
estparmtd(x, eps = 1e-6, display = FALSE, plot = display)
}
\arguments{
\item{x}{numeric matrix or data frame.}

\item{eps}{numeric. Precision for the estimation of the parameters.}

\item{display}{logical. When \code{TRUE} the value of the \code{nu} parameter at each iteration is printed.}

\item{plot}{logical. When \code{TRUE} the successive values of the \code{nu} parameter are plotted, allowing to visualise its convergence.}
}
\value{
A list of 3 elements:
\itemize{
\item \code{nu} non-negative numeric value. The degrees of freedom.
\item \code{mu} the mean vector.
\item \code{Sigma}: symmetric positive-definite matrix. The correlation matrix.
}
with two attributes \code{attr(, "epsilon")} (precision of the result) and \code{attr(, "k")} (number of iterations).
}
\description{
Estimation of the degrees of freedom, mean vector and correlation matrix of a multivariate \eqn{t} distribution (MTD).
}
\details{
The EM method is used to estimate the parameters.
}
\examples{
nu <- 3
mu <- c(0, 1, 4)
Sigma <- matrix(c(1, 0.6, 0.2, 0.6, 1, 0.3, 0.2, 0.3, 1), nrow = 3)
x <- rmtd(100, nu, mu, Sigma)

# Estimation of the parameters
estparmggd(x)

}
\references{
Doğru, F., Bulut, Y. M. and Arslan, O. (2018).
Doubly reweighted estimators for the parameters of the multivariate t-distribution.
Communications in Statistics - Theory and Methods. 47.
\doi{10.1080/03610926.2018.1445861}.
}
\seealso{
\code{\link{dmtd}}: probability density of a MTD

\code{\link{rmtd}}: random generation from a MTD.
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
