% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anaglyph.R
\name{anazero_fingerprint}
\alias{anazero_fingerprint}
\title{Are regularities within or between sets in a pair?}
\usage{
anazero_fingerprint(set, edo = 12, rounder = 10)
}
\arguments{
\item{set}{A vector of even length representing a pair of sets}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
A vector with three entries, representing regularities in the
first set, regularities in the second set, and regularities between them.
}
\description{
As for other hyperplane arrangements, it is useful to consider the
number of entries which equal 0 in an anaglyph signvector. However,
such entries can represent three different types of regularity:
regularity within the first set, regularity within the second set, or
regularity in the comparison between them. This function distinguishes
between those three types of hyperplanes.
}
\examples{
maj <- c(0, 4, 7)
sus2 <- c(0, 2, 7)
anazero_fingerprint(c(maj, sus2))

# The first zero shows that the major triad has no regularities.
# This is equivalent to:
countsvzeroes(maj)

# The second zero shows that the sus2 trichord has 1 regularity.
# This is equivalent to:
countsvzeroes(sus2)

# The final zero shows that the major triad's perfect fifth
# equals the size of the *two* perfect fifths in the sus2 trichord.
# We can visualize the whole set of relationships using a brightness
# graph:
brightnessgraph(maj, sus2)

}
\seealso{
\code{\link[=make_anaglyph_ineqmat]{make_anaglyph_ineqmat()}}, \code{\link[=svzero_fingerprint]{svzero_fingerprint()}}
}
