\name{summary}
\alias{summary}
\alias{summary.mxrpc}
\alias{summary.mxspc}
\title{A Brief Summary of Control Chart Parameters and Data}
\description{
  This function provides a summary for the control charts generated by the
  \code{mxrpc} and \code{mxspc} functions. This function also provide a brief summary of data being used for analysis.
}
\usage{
summary(object, ...)
}
\arguments{
  \item{object}{An object of class \code{mxrpc} or \code{mxspc}, typically created by the \code{mxrpc()} or \code{mxspc()} function.}
  \item{...}{Additional arguments passed to the method (currently unused).}
}
\details{
  This method returns a list summarizing the control chart parameters such as subgroup size, sample size, control limits (LCL, CL, UCL), and standard deviation. It also includes summary statistics of the plotted statistic and the original or simulated data, depending on the function used.
}
\value{
  A list of class \code{summary.mxrpc} or \code{summary.mxspc}, containing the control chart parameters and summary statistics of the data.
}
\references{
Hossain, M.P., Omar, M.H. and Riaz, M. (2017) "New V control chart for the Maxwell distribution". Journal of Statistical Computation and Simulation, 87(3), pp.594-606. <doi:10.1080/00949655.2016.1222391>

Shah, F., Khan, Z., Aslam, M. and Kadry, S. (2021) "Statistical Development of the VSQ‐Control Chart for Extreme Data with an Application to the Carbon Fiber Industry". Mathematical Problems in Engineering, 2021(1), p.9766986. <doi:10.1155/2021/9766986>
}
\examples{

# Assuming `t1` is an object returned by the mxspc() function
# Maxwell control chart for simulated data
t1 <- mxspc(m = 40, n = 3, alpha = 0.0027, sigma = 1.5, limit = "KCL")
summary(t1)
}

