source("libtest.R")

test_that("mc_filter raw format", {
    data <- mc_read_data("../data/TOMST/files_table2.csv", clean=FALSE)
    filtered <- mc_filter(data)
    test_raw_data_format(filtered)
    expect_equal(length(filtered$localities), 3)
    filtered <- mc_filter(data, c("A2E32", "A1E05"))
    test_raw_data_format(filtered)
    expect_equal(names(filtered$localities), c("A1E05", "A2E32"))
    expect_equal(length(filtered$localities$A1E05$loggers), 2)
    expect_equal(length(filtered$localities$A1E05$loggers[["Thermo_1"]]$sensors), 1)
    expect_equal(length(filtered$localities$A1E05$loggers[["TMS_1"]]$sensors), 4)
    expect_equal(length(filtered$localities$A2E32$loggers[["TMS_1"]]$sensors), 4)
    filtered <- mc_filter(data, sensors=c("TMS_T1", "TMS_T2"))
    test_raw_data_format(filtered)
    expect_equal(names(filtered$localities), c("A1E05", "A2E32"))
    expect_equal(length(filtered$localities$A1E05$loggers), 1)
    expect_equal(length(filtered$localities$A1E05$loggers[["TMS_1"]]$sensors), 2)
    expect_equal(length(filtered$localities$A2E32$loggers[["TMS_1"]]$sensors), 2)
    filtered <- mc_filter(data, localities=c("A6W79", "A2E32", "A1E05"), sensors="TMS_T2")
    test_raw_data_format(filtered)
    expect_equal(names(filtered$localities), c("A1E05", "A2E32"))
    expect_equal(length(filtered$localities$A1E05$loggers), 1)
    expect_equal(length(filtered$localities$A1E05$loggers[["TMS_1"]]$sensors), 1)
    expect_equal(length(filtered$localities$A2E32$loggers[["TMS_1"]]$sensors), 1)
    filtered <- mc_filter(data, localities="A2E32", sensors="TMS_T3")
    expect_equal(names(filtered$localities), "A2E32")
    expect_equal(names(filtered$localities$A2E32$loggers[["TMS_1"]]$sensors), "TMS_T3")
})

test_that("mc_filter reverse raw format", {
    data <- mc_read_data("../data/TOMST/files_table2.csv", clean=FALSE)
    expect_error(filtered <- mc_filter(data, reverse = TRUE))
    filtered <- mc_filter(data, localities=c("A2E32", "A1E05"), reverse=TRUE)
    test_raw_data_format(filtered)
    expect_equal(names(filtered$localities), "A6W79")
    expect_equal(length(filtered$localities$A6W79$loggers[[1]]$sensors), 4)
    filtered <- mc_filter(data, sensors=c("TMS_T1", "TMS_T2"), reverse=TRUE)
    test_raw_data_format(filtered)
    expect_equal(length(filtered$localities), 3)
    expect_equal(length(filtered$localities$A1E05$loggers), 2)
    expect_equal(length(filtered$localities$A1E05$loggers[[1]]$sensors), 1)
    expect_equal(length(filtered$localities$A1E05$loggers[[2]]$sensors), 2)
    expect_equal(length(filtered$localities$A2E32$loggers[[1]]$sensors), 2)
    expect_equal(length(filtered$localities$A6W79$loggers[[1]]$sensors), 4)
    data <- mc_read_data("../data/TOMST/files_table.csv", clean=FALSE)
    filtered <- mc_filter(data, localities="A6W79", sensors="TMS_T2", reverse=TRUE)
    expect_equal(length(filtered$localities), 3)
    expect_equal(length(filtered$localities$A6W79$loggers$TMS_1$sensors), 3)
    expect_equal(length(filtered$localities$A2E32$loggers$TMS_1$sensors), 4)
})

test_that("mc_filter agg format", {
    cleaned_data <- mc_read_data("../data/TOMST/files_table.csv", silent=T)
    agg_data <- mc_agg(cleaned_data)
    filtered <- mc_filter(agg_data, localities=c("A6W79", "A2E32", "A1E05"), sensors="TMS_T2")
    test_agg_data_format(filtered)
    expect_equal(length(filtered$localities), 2)
    expect_equal(length(filtered$localities$A2E32$sensors), 1)
    expect_equal(length(filtered$localities$A6W79$sensors), 1)
    expect_false("TMS_T1" %in% names(filtered$localities$A6W79$sensors))
    expect_true("TMS_T2" %in% names(filtered$localities$A6W79$sensors))
})

test_that("mc_filter reverse agg format", {
    cleaned_data <- mc_read_data("../data/TOMST/files_table.csv", silent=T)
    agg_data <- mc_agg(cleaned_data)
    filtered <- mc_filter(agg_data, localities="A6W79", sensors="TMS_moist", reverse=TRUE)
    test_agg_data_format(filtered)
    expect_false("TMS_moist" %in% names(filtered$localities$A6W79$sensors))
    expect_true("TMS_moist" %in% names(filtered$localities$A2E32$sensors))
    filtered <- mc_filter(agg_data, sensors="Thermo_T", reverse=TRUE)
    test_agg_data_format(filtered)
    expect_equal(length(filtered$localities), 2)
    expect_equal(length(filtered$localities$A2E32$sensors), 4)
})

test_that("mc_filter logger_types", {
    cleaned_data <- mc_read_data("../data/TOMST/files_table.csv", silent=TRUE)
    agg_data <- mc_agg(cleaned_data)
    expect_error(filtered <- mc_filter(agg_data, logger_types="TMS"))
    filtered <- mc_filter(cleaned_data, logger_types="TMS")
    expect_equal(names(filtered$localities), c("A2E32", "A6W79"))
    filtered <- mc_filter(cleaned_data, logger_types="TMS", reverse=TRUE)
    expect_equal(names(filtered$localities), c("A1E05"))
    filtered <- mc_filter(cleaned_data, sensors="TMS_T1", logger_types="TMS")
    expect_equal(length(filtered$localities), 2)
    expect_equal(names(filtered$localities$A2E32$loggers[[1]]$sensors), "TMS_T1")
    filtered <- mc_filter(cleaned_data, sensors="TMS_T1", logger_types="Thermo", reverse = TRUE)
    expect_error(filtered <- mc_filter(cleaned_data, localities="A1E05", logger_types="TMS"))
    filtered <- mc_filter(cleaned_data, localities="A2E32", logger_types="TMS", reverse = TRUE)
    expect_equal(length(filtered$localities), 2)
})

test_that("mc_filter loggers", {
    cleaned_data <- mc_read_data("../data/TOMST/files_table.csv", silent=T)
    agg_data <- mc_agg(cleaned_data)
    expect_error(filtered <- mc_filter(agg_data, loggers="TMS_1"))
    expect_error(filtered <- mc_filter(cleaned_data, loggers="TMS_1", logger_types="TMS"))
    filtered <- mc_filter(cleaned_data, loggers="TMS_1")
    expect_equal(names(filtered$localities), c("A2E32", "A6W79"))
    filtered <- mc_filter(cleaned_data, loggers="TMS_1", reverse=TRUE)
    expect_equal(names(filtered$localities), c("A1E05"))
    filtered <- mc_filter(cleaned_data, sensors="TMS_T1", loggers="TMS_1")
    expect_equal(length(filtered$localities), 2)
    expect_equal(names(filtered$localities$A2E32$loggers[[1]]$sensors), "TMS_T1")
    filtered <- mc_filter(cleaned_data, sensors="TMS_T1", loggers="Thermo_1", reverse = TRUE)
    expect_error(filtered <- mc_filter(cleaned_data, localities="A1E05", loggers="TMS_1"))
    filtered <- mc_filter(cleaned_data, localities="A1E05", loggers="TMS_1", reverse = TRUE)
    filtered <- mc_filter(cleaned_data, localities="A2E32", loggers="TMS_1")
    expect_equal(length(filtered$localities), 1)
    filtered <- mc_filter(cleaned_data, localities="A2E32", loggers="TMS_1", reverse = TRUE)
    expect_equal(length(filtered$localities), 2)
    files_table <- read.csv("../data/TOMST/files_table.csv")
    files_table$locality_id[[1]] <- "A2E32"
    files_table$path <- stringr::str_c("../data/TOMST/", files_table$path)
    cleaned_data <- mc_read_data(files_table, silent=T)
    filtered <- mc_filter(cleaned_data, localities="A2E32", loggers="TMS_2")
    expect_equal(names(filtered$localities$A2E32$loggers), "TMS_2")
    filtered <- mc_filter(cleaned_data, loggers="TMS_1", reverse=TRUE)
    expect_equal(names(filtered$localities$A2E32$loggers), "TMS_2")
})

