% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.netcomb.R
\name{forest.netcomb}
\alias{forest.netcomb}
\alias{plot.netcomb}
\title{Forest plot for additive network meta-analysis}
\usage{
\method{forest}{netcomb}(
  x,
  pooled = ifelse(x$random, "random", "common"),
  reference.group = x$reference.group,
  baseline.reference = x$baseline.reference,
  equal.size = gs("equal.size"),
  leftcols = "studlab",
  leftlabs = "Treatment",
  rightcols = c("effect", "ci"),
  rightlabs = NULL,
  digits = gs("digits.forest"),
  smlab = NULL,
  sortvar = x$seq,
  overall.hetstat = gs("overall.hetstat"),
  backtransf = x$backtransf,
  lab.NA = gs("lab.NA"),
  add.data,
  addrows.below.overall = if (x$overall.hetstat) 2 else gs("addrows.below.overall"),
  drop.reference.group = gs("drop.reference.group"),
  ...
)

\method{plot}{netcomb}(x, ...)
}
\arguments{
\item{x}{An object of class \code{netcomb}.}

\item{pooled}{A character string indicating whether results for the
common (\code{"common"}) or random effects model (\code{"random"})
should be plotted. Can be abbreviated.}

\item{reference.group}{Reference treatment(s).}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa.}

\item{equal.size}{A logical indicating whether all squares should
be of equal size. Otherwise, the square size is proportional to
the precision of estimates.}

\item{leftcols}{A character vector specifying (additional) columns
to be plotted on the left side of the forest plot or a logical
value (see \code{\link[meta]{forest.meta}} help page for details).}

\item{leftlabs}{A character vector specifying labels for
(additional) columns on left side of the forest plot (see
\code{\link[meta]{forest.meta}} help page for details).}

\item{rightcols}{A character vector specifying (additional) columns
to be plotted on the right side of the forest plot or a logical
value (see \code{\link[meta]{forest.meta}} help page for details).}

\item{rightlabs}{A character vector specifying labels for
(additional) columns on right side of the forest plot (see
\code{\link[meta]{forest.meta}} help page for details).}

\item{digits}{Minimal number of significant digits for treatment
effects and confidence intervals, see \code{print.default}.}

\item{smlab}{A label printed at top of figure. By default, text
indicating either common or random effects model is printed.}

\item{sortvar}{An optional vector used to sort the individual
studies (must be of same length as the total number of
treatments).}

\item{overall.hetstat}{A logical indicating whether to print heterogeneity
measures.}

\item{backtransf}{A logical indicating whether results should be
back transformed in forest plots. If \code{backtransf = TRUE},
results for \code{sm = "OR"} are presented as odds ratios rather
than log odds ratios, for example.}

\item{lab.NA}{A character string to label missing values.}

\item{add.data}{An optional data frame with additional columns to
print in forest plot (see Details).}

\item{addrows.below.overall}{A numeric value indicating how many
empty rows are printed between meta-analysis results and
heterogeneity statistics.}

\item{drop.reference.group}{A logical indicating whether the
reference group should be printed in the forest plot.}

\item{\dots}{Additional arguments for \code{\link[meta]{forest.meta}}
function.}
}
\description{
Draws a forest plot in the active graphics window (using grid
graphics system).
}
\details{
A forest plot, also called confidence interval plot, is drawn in
the active graphics window.

Argument \code{sortvar} can be either a numeric or character vector
with length of number of treatments. If \code{sortvar} is numeric
the \code{\link[base]{order}} function is utilised internally to
determine the order of values. If \code{sortvar} is character it
must be a permutation of the treatment names. It is also possible
to to sort by treatment comparisons (\code{sortvar = TE}, etc.),
standard error (\code{sortvar = seTE}), and number of studies with
direct treatment comparisons (\code{sortvar = k}).

Argument \code{add.data} can be used to add additional columns to
the forest plot. This argument must be a data frame with the same
row names as the treatment effects matrices in R object \code{x},
i.e., \code{x$TE.common} or \code{x$TE.random}.

For more information see help page of \code{\link[meta]{forest.meta}}
function.
}
\examples{
# Examples: example(netcomb)

}
\seealso{
\code{\link{netcomb}}, \code{\link{discomb}},
  \code{\link[meta]{forest.meta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{hplot}
