% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nac_test.R
\name{nac_test}
\alias{nac_test}
\title{NAC test}
\usage{
nac_test(A, K, z = NULL, y = NULL, plus = TRUE, cluster_fct = spec_clust, ...)
}
\arguments{
\item{A}{adjacency matrix.}

\item{K}{number of communities.}

\item{z}{label vector for rows of \code{A}. If not provided, will be estimated from \code{cluster_fct}.}

\item{y}{label vector for columns of \code{A}. If not provided, will be estimated from \code{cluster_fct}.}

\item{plus}{whether or not use column label vector with (\code{K}+1) communities, default is TRUE.}

\item{cluster_fct}{community detection function to get \code{z} and \code{y}, by default using \link{spec_clust}.
The first two arguments have to be \code{A} and \code{K}.}

\item{...}{additional arguments for \code{cluster_fct}.}
}
\value{
A list of result
\item{stat}{NAC or NAC+ test statistic.}
\item{z}{row label vector.}
\item{y}{column label vector.}
}
\description{
The NAC test to measure the goodness-of-fit of the DCSBM to network data.

The function computes the NAC+ or NAC statistics in the paper below. Label vectors, if
not provided, are estimated using \link{spec_clust} by default but one can also use any other
community detection algorithms through \code{cluster_fct}. Note that the function has to have
\code{A} and \code{K} as its first two arguments, and additional arguments could be provided through
\code{...}.
}
\section{References}{
 \href{https://arxiv.org/abs/2012.15047}{Adjusted chi-square test for degree-corrected block models},
Linfan Zhang, Arash A. Amini, arXiv preprint arXiv:2012.15047, 2020.
}

\examples{
A <- sample_dcpp(500, 10, 4, 0.1)$adj
nac_test(A, K = 4)$stat
nac_test(A, K = 4, cluster_fct = fast_cpl)$stat
}
\seealso{
\link{snac_test}
}
