% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppp_exactly_n.R
\name{ppp_exactly_n}
\alias{ppp_exactly_n}
\title{Simulate exactly \code{n} points from a homogeneous Poisson Point Process over (t_min, t_max]}
\usage{
ppp_exactly_n(n, t_min, t_max)
}
\arguments{
\item{n}{(int) the number of points to be simulated}

\item{t_min}{(double) the lower bound of the time interval}

\item{t_max}{(double) the upper bound of the time interval}
}
\value{
a vector of event times of size \code{n}
}
\description{
Simulate exactly \code{n} points from a homogeneous Poisson Point Process over (t_min, t_max]
}
\examples{
x <- ppp_exactly_n(n = 10, t_min = 0, t_max = 10)
}
