% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vztdraw_intensity.R
\name{vztdraw_intensity}
\alias{vztdraw_intensity}
\title{Vectorized sampling from a zero-truncated non homogeneous Poisson Point Process (NHPPP) from
an interval (thinning method) with piecewise constant_majorizers}
\usage{
vztdraw_intensity(
  lambda = NULL,
  lambda_args = NULL,
  Lambda_maj_matrix = NULL,
  lambda_maj_matrix = NULL,
  range_t = NULL,
  tol = 10^-6,
  atmost1 = FALSE,
  ...
)
}
\arguments{
\item{lambda}{(function) a vectorized intensity function, with one or two arguments.
The first is time. The optional second is a named list with additional arguments.}

\item{lambda_args}{(list) optional list of named arguments for \code{lambda()}}

\item{Lambda_maj_matrix}{(matrix) for the majorizeintegrated intensity rates at the end of each interval}

\item{lambda_maj_matrix}{(matrix) intensity rates, one per interval}

\item{range_t}{(vector, or matrix) \code{t_min} and \code{t_max}, possibly vectorized}

\item{tol}{(scalar, double) tolerance for the number of events}

\item{atmost1}{boolean, draw at most 1 event time}

\item{...}{(any) other arguments (ignored  -- used for flexibility in calling from other functions)}
}
\value{
a matrix of event times (columns) per draw (rows)
NAs are structural empty spots
}
\description{
Vectorized sampling from a zero-truncated non homogeneous Poisson Point Process (NHPPP) from
an interval (thinning method) with piecewise constant_majorizers.
The majorizers are step functions over equal-length time intevals.
}
\keyword{internal}
