% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmultiLocal_normal.R
\name{dmultiLocal_normal}
\alias{dmultiLocal_normal}
\alias{rmultiLocal_normal}
\title{Local evaluation of a multinomial SCR detection process}
\usage{
dmultiLocal_normal(
  x,
  detNums = -999,
  detIndices,
  size,
  p0 = -999,
  p0Traps,
  sigma,
  s,
  trapCoords,
  localTrapsIndices,
  localTrapsNum,
  resizeFactor = 1,
  habitatGrid,
  indicator,
  lengthYCombined = 0,
  log = 0
)

rmultiLocal_normal(
  n = 1,
  detNums = -999,
  detIndices,
  size,
  p0 = -999,
  p0Traps,
  sigma,
  s,
  trapCoords,
  localTrapsIndices,
  localTrapsNum,
  resizeFactor = 1,
  habitatGrid,
  indicator,
  lengthYCombined = 0
)
}
\arguments{
\item{x}{Vector of individual detection frequencies. This argument can be provided in two formats: 
(i) with the \emph{y} object as returned by the \code{\link{getSparseY}} function;
(ii) with the \emph{yCombined} object as returned by \code{\link{getSparseY}}. 
Note that when the random generation functionality is used (\code{rmultiLocal_normal}), only the \emph{yCombined} format can be used. 
The \emph{yCombined} object combines \emph{detNums}, \emph{x}, and \emph{detIndices} (in that order).  When such consolidated representation of the detection data \emph{x} is used, \emph{detIndices} and \emph{detNums} arguments should not be specified.}

\item{detNums}{umber of traps with at least one detection recorded in \emph{x}; from the \emph{detNums} object returned by the \code{\link{getSparseY}} function. 
This argument should not be specified when the \emph{yCombined} object (returned by \code{\link{getSparseY}}) is provided as \emph{x} and when detection data are simulated.}

\item{detIndices}{Vector of indices of traps where the detections in \emph{x} were recorded; from the \emph{detIndices} object returned by the \code{\link{getSparseY}} function. 
This argument should not be specified when x is provided as the  \emph{yCombined} object (returned by \code{\link{getSparseY}} ) and when detection data are simulated.}

\item{size}{Number of occasions.}

\item{p0}{Baseline detection probability (scalar) used in the half-normal detection function. For trap-specific baseline detection probabilities use argument \emph{p0Traps} (vector) instead.}

\item{p0Traps}{Vector of baseline detection probabilities for each trap used in the half-normal detection function. When \emph{p0Traps} is used, \emph{p0} should not be provided.}

\item{sigma}{Scale parameter of the half-normal detection function.}

\item{s}{Individual activity center x- and y-coordinates scaled to the habitat (see (\code{\link{scaleCoordsToHabitatGrid}})).}

\item{trapCoords}{Matrix of x- and y-coordinates of all traps scaled to the habitat (see (\code{\link{scaleCoordsToHabitatGrid}})).}

\item{localTrapsIndices}{Matrix of indices of local traps around each habitat grid cell, as returned by the \code{\link{getLocalObjects}} function.}

\item{localTrapsNum}{Vector of numbers of local traps around all habitat grid cells, as returned by the \code{\link{getLocalObjects}} function.}

\item{resizeFactor}{Aggregation factor used in the \code{\link{getLocalObjects}} function to reduce the number of habitat grid cells to retrieve local traps for.}

\item{habitatGrid}{Matrix of local habitat grid cell indices, from \emph{habitatGrid} returned by the \code{\link{getLocalObjects}} function.}

\item{indicator}{Binary argument specifying whether the individual is available for detection (indicator = 1) or not (indicator = 0).}

\item{lengthYCombined}{The length of the x argument when the (\emph{yCombined}) format of the detection data is provided;  from the \emph{lengthYCombined} object returned by \code{\link{getSparseY}}}

\item{log}{Logical argument, specifying whether to return the log-probability of the distribution.}

\item{n}{Integer specifying the number of realizations to generate.  Only n = 1 is supported.}
}
\value{
The log-likelihood value associated with the vector of detections, given the location of the activity center (s),
 and the half-normal detection function : \eqn{p = p0 * exp(-d^2 / 2 \sigma^2)}.
}
\description{
The \code{dmultiLocal_normal} distribution is a NIMBLE custom distribution which can be used to model 
and simulate multinomial observations (x) of a single individual over a set of traps defined by their coordinates \emph{trapCoords}
the distribution assumes that an individual’s detection probability at any trap follows a half-normal function of the distance between 
the individual's activity center (s) and the trap location. All coordinates (\code{s} and \code{trapCoords}) should be scaled to the habitat (see \code{\link{scaleCoordsToHabitatGrid}})
}
\details{
The \code{dmultiLocal_normal} distribution incorporates three features to increase computation efficiency (see Turek et al., 2021 <doi.org/10.1002/ecs2.3385>  for more details):
\enumerate{
\item A local evaluation of the detection probability calculation (see Milleret et al., 2019 <doi:10.1002/ece3.4751> for more details)
\item A sparse matrix representation (\emph{x}, \emph{detIndices} and \emph{detNums}) of the observation data to reduce the size of objects to be processed.
\item An indicator (\emph{indicator}) to shortcut calculations for individuals unavailable for detection.
}

The \code{dmultiLocal_normal} distribution requires x- and y- detector coordinates (\emph{trapCoords}) and activity centers coordinates (\emph{s}) to be scaled to the habitat grid (\emph{habitatGrid}) using the (\code{\link{scaleCoordsToHabitatGrid}} function.)

When the aim is to simulate detection data: 
\enumerate{
\item \emph{x} should be provided using the \emph{yCombined} object as returned by \code{\link{getSparseY}}, 
\item arguments \emph{detIndices} and \emph{detNums} should not be provided, 
\item argument \emph{lengthYCombined} should be provided using the \emph{lengthYCombined} object as returned by  \code{\link{getSparseY}}.
}
}
\examples{
# I. DATA SET UP 
coordsHabitatGridCenter <- matrix(c(0.5, 3.5,
                                   1.5, 3.5,
                                   2.5, 3.5,
                                   3.5, 3.5,
                                   0.5, 2.5,
                                   1.5, 2.5,
                                   2.5, 2.5,
                                   3.5, 2.5,
                                   0.5, 1.5,
                                   1.5, 1.5,
                                   2.5, 1.5,
                                   3.5, 1.5,
                                   0.5, 0.5,
                                   1.5, 0.5,
                                   2.5, 0.5,
                                   3.5, 0.5), ncol=2,byrow = TRUE)
colnames(coordsHabitatGridCenter) <- c("x","y")
# CREATE OBSERVATION WINDOWS
trapCoords <- matrix(c(1.5, 1.5, 2.5, 1.5, 1.5, 2.5, 2.5, 2.5), nrow = 4, byrow = TRUE)
colnames(trapCoords) <- c("x","y")
# PLOT CHECK
plot(coordsHabitatGridCenter[,"y"]~coordsHabitatGridCenter[,"x"],pch=16) 
points(trapCoords[,"y"]~trapCoords[,"x"],col="red",pch=16) 

# PARAMETERS
p0 <- 0.2
sigma <- 2
indicator <- 1 
# WE CONSIDER 2 INDIVIDUALS

y <- matrix(c(2, 1, 1,-1, 1, 4, -1,#id#1 detected 2 times at detector 1 and 4 
             2, 2,-1,-1, 3,-1, -1),#id#2 detected 2 times at detector 3
              ncol=7, nrow=2, byrow = TRUE)




s <- matrix(c(0.5, 1,
             1.6, 2.3),ncol=2,nrow=2)

# RESCALE COORDINATES 
ScaledtrapCoords <- scaleCoordsToHabitatGrid(coordsData =  trapCoords,
                                            coordsHabitatGridCenter = coordsHabitatGridCenter)
ScaledtrapCoords<- ScaledtrapCoords$coordsDataScaled
habitatMask <- matrix(1, nrow = 4, ncol=4, byrow = TRUE)


# CREATE LOCAL OBJECTS 
TrapLocal <- getLocalObjects(habitatMask = habitatMask,
                                  coords = ScaledtrapCoords,
                                  dmax=2.5,
                                  resizeFactor = 1,
                                  plot.check = TRUE
)

# GET SPARSE MATRIX 
#SparseY <- getSparseY(y)

# II. USING THE DENSITY FUNCTION 
# WE TAKE THE FIRST INDIVIDUAL
i=1
 # OPTION 1: USING THE RANDOM GENERATION FUNCTIONNALITY 
dmultiLocal_normal(x=y[i,]
                  ,
                  size=3
                  ,
                  p0 = p0
                  ,
                  sigma= sigma
                  , 
                  s=s[i,1:2]
                  ,
                  trapCoords=ScaledtrapCoords
                  ,
                  localTrapsIndices=TrapLocal$localIndices
                  ,
                  localTrapsNum=TrapLocal$numLocalIndices
                  ,
                  resizeFactor=TrapLocal$resizeFactor
                  ,
                  habitatGrid=TrapLocal$habitatGrid
                  ,
                  indicator=indicator
                  ,
                  lengthYCombined = ncol(y)
                  )
                                                               
 

# III. USING THE RANDOM GENERATION FUNCTION 
rmultiLocal_normal(n=1,
                  size=3,
                  p0 = p0,
                  sigma= sigma, 
                  s=s[i,1:2],
                  trapCoords=ScaledtrapCoords,
                  localTrapsIndices=TrapLocal$localIndices,
                  localTrapsNum=TrapLocal$numLocalIndices,
                  resizeFactor=TrapLocal$resizeFactor,
                  habitatGrid=TrapLocal$habitatGrid,
                  indicator=indicator,
                  lengthYCombined = ncol(y))
                  
}
\author{
Soumen Dey, Cyril Milleret
}
