% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/o2plsda.R
\name{oplsda}
\alias{oplsda}
\title{Orthogonal partial least squares discriminant analysis}
\usage{
oplsda(X, Y, nc, scale = FALSE, center = TRUE, maxiter = 100, tol = 1e-05)
}
\arguments{
\item{X}{a O2pls object or a matrix of predictor variables.}

\item{Y}{a single vector indicate the group}

\item{nc}{the number of pls components (the one joint components + 
number of orthogonal components ).}

\item{scale}{logical indicating whether \code{X} must be scaled (suggest TRUE).}

\item{center}{boolean values determining if data should be centered or not}

\item{maxiter}{maximum number of iterations.}

\item{tol}{limit for convergence of the algorithm in the nipals algorithm.}
}
\value{
a list containing the following elements:
\itemize{
\item{}\code{nc} the number of components used(one joint components + 
 number of orthogonal components 
\item{}\code{scores} a matrix of scores corresponding to the observations 
in \code{X}, The components retrieved correspond to the ones optimized 
or specified.
\item{}\code{Xloadings} a matrix of loadings corresponding to the
 explanatory variables. The components retrieved correspond to the ones
 optimized or specified.
\item{}\code{Yloadings} a matrix of partial least squares loadings
 corresponding to \code{Y}
\item{}\code{vip} the VIP matrix.
\item{}\code{xvar} a matrix indicating the standard deviation of each
 component (sd), the variance explained by each single component
 (explained_var) and the cumulative explained variance
 (cumulative_explained_var). These values are
 computed based on the data used to create the projection matrices.
\item{}\code{projection_matrix} the matrix of projection matrix
\item{}\code{weight} a matrix of partial least squares ("pls") weights.
}
}
\description{
Computes orthogonal scores partial least squares 
regressions with the NIPALS algorithm. It return a comprehensive set of
pls outputs (e.g. scores and vip).
}
\examples{
X <- matrix(rnorm(50),10,5)
Y <- matrix(rnorm(50),10,5)
fit <- o2pls(X,Y,2,1,1)
yy <- rep(c(0,1),5)
fit0 <- oplsda(fit,yy,2)
}
\author{
Kai Guo
}
