% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-estimate_op.R
\name{estimate_op}
\alias{estimate_op}
\title{Estimate all standard RAM-OP indicators}
\usage{
estimate_op(
  x,
  w,
  indicators = c("demo", "anthro", "food", "hunger", "adl", "disability", "mental",
    "dementia", "health", "oedema", "screening", "income", "wash", "visual", "misc"),
  replicates = 399
)
}
\arguments{
\item{x}{Indicators dataset produced by \code{\link[=create_op]{create_op()}} with primary sampling
unit (PSU) in column named \emph{"psu"}`}

\item{w}{A data frame with primary sampling unit (PSU) in column named
\emph{"psu"} and survey weight (i.e. PSU population) in column named \emph{"pop"}.}

\item{indicators}{A character vector of indicator set names to estimate.
Indicator set names are \emph{"demo"}, \emph{"anthro"}, \emph{"food"}, \emph{"hunger"},
\emph{"disability"}, \emph{"adl"}, \emph{"mental"}, \emph{"dementia"}, \emph{"health"}, \emph{"income"},
\emph{"wash"}, \emph{"visual"}, and \emph{"misc"}. Default is all indicator sets.}

\item{replicates}{Number of bootstrap replicates. Default is 399.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} of boot estimates for all specified standard
RAM-OP indicators.
}
\description{
Estimate all standard RAM-OP indicators
}
\examples{
estimate_op(x = create_op(testSVY), w = testPSU, replicates = 9)

}
