% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-probit_muac.R
\name{probit_gam}
\alias{probit_gam}
\alias{probit_sam}
\title{PROBIT statistics function for bootstrap estimation of older people GAM}
\usage{
probit_gam(x, params, threshold = 210)

probit_sam(x, params, threshold = 185)
}
\arguments{
\item{x}{A data frame with primary sampling unit (PSU) in column named
\emph{"psu"} and with data column/s containing the continuous variable/s of
interest with column names corresponding to \code{params} values}

\item{params}{A vector of column names corresponding to the continuous
variables of interest contained in \code{x}}

\item{threshold}{cut-off value for continuous variable to differentiate
case and non-case. Default is set at 210 for \code{\link[=probit_gam]{probit_gam()}} and 185 for
\code{\link[=probit_sam]{probit_sam()}}.}
}
\value{
A numeric vector of the PROBIT estimate of each continuous variable
of interest with length equal to \code{length(params)}.
}
\description{
PROBIT statistics function for bootstrap estimation of older people GAM
}
\examples{

# Example call to bootBW function:
probit_gam(x = indicators.ALL, params = "MUAC", threshold = 210)
probit_sam(x = indicators.ALL, params = "MUAC", threshold = 185)

}
