% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{lp}
\alias{lp}
\title{First-order low-pass filtering}
\usage{
lp(X, a1, usestate = TRUE)
}
\arguments{
\item{X}{Dataframe or matrix (or list of them) of forecasts in columns to be low-pass filtered.}

\item{a1}{The low-pass filter coefficient.}

\item{usestate}{logical: Use the state kept in the model$input? if \code{lp()} is used outside model$transform_data(), then it must be set to FALSE, otherwise the input$state (which is not there) will be read leading to an error.}
}
\value{
The low-pass filtered dataframe (as a matrix)
}
\description{
First-order low-pass filtering of time series.
}
\details{
This function applies a first order unity gain low-pass filter to the columns of \code{X}.
The low-pass filter is applied to each column seperately. The stationary gain of the filter i one.

If a list of dataframes (or matrices) is given, then the low-pass filtering is recursively applied on each.
}
\examples{
# Make a dataframe for the examples
X <- data.frame(k1=rep(c(0,1),each=5))
X$k2 <- X$k1
Xf <- lp(X, 0.5, usestate=FALSE)
Xf

# See the input and the low-pass filtered result
plot(X$k1)
lines(Xf[ ,"k1"])
# Slower response with higher a1 value
lines(lp(X, 0.8, usestate=FALSE)[ ,"k1"])

# If a list of dataframes is given, then lp() is recursively applied on each
lp(list(X,X), 0.5, usestate=FALSE)


}
