% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Viz_manipul_main.R
\name{paths_sunburst}
\alias{paths_sunburst}
\title{Return ontology paths for characters}
\usage{
paths_sunburst(
  ontology,
  annotations = "auto",
  exclude.terms = NULL,
  include.terms = NULL,
  use.chars = TRUE,
  sep = "-"
)
}
\arguments{
\item{ontology}{ontology_index object with character annatotions included.}

\item{annotations}{which annotations to use: "auto" means automatic annotations, "manual" means manual ones.
Alternatively, any othe list element containing annotations can be specified.}

\item{exclude.terms}{list of terms to exclude}

\item{include.terms}{list of terms to include}

\item{use.chars}{indicate whether character ids should be included in output}

\item{sep}{separator used to delimit ontology terms}
}
\value{
Table.
}
\description{
Returns ontology paths for all characters. These paths can be used to create a sunburst plot of
ontological dependencies.
}
\examples{
\donttest{
ontology_partof=get_OBO(system.file("data_onto", "HAO.obo", package = "ontoFAST"),
extract_tags="everything", propagate_relationships = c("BFO:0000050"))
ontology_partof<-onto_process(ontology_partof, Sharkey_2011[,1], do.annot = F)
ontology_partof$annot_characters<-Sharkey_2011_annot
tb<-paths_sunburst(ontology_partof,
annotations = ontology_partof$annot_characters, exclude.terms=exclude_terms)
# library(sunburst)
sunburst(tb)
}
}
