% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_search_term.R
\name{format_search_term}
\alias{format_search_term}
\title{Format character vectors into \code{search} terms for openFDA API queries}
\usage{
format_search_term(search, exact = TRUE, mode = "or")
}
\arguments{
\item{search}{A character vector of length 1 or more. If scalar and unnamed,
it will be assumed that you have already formatted your search string to
work with the API. If named, the vector will be collapsed to include your
various search terms, separated by AND or OR terms based on the value of
\code{operator}.}

\item{exact}{A single-length logical vector. When \code{TRUE} (the default),
individual search terms will be surrounded with double quotes (\code{""}). Set
\code{exact} to \code{FALSE} if your search term contains multiple words to be
searched on, e.g. \code{c("openfda.generic_name" = "losartan+candesartan")}.

This parameter only applies if \code{search} is a named character vector.}

\item{mode}{A single-length character vector, which defines how searches in
multiple fields should be combined. By default (\code{"or"}) they will be
combined with an 'OR' operator, but you can make an 'AND' operator be used
instead (\code{"and"}). This argument is case-sensitive and will throw an error
if \code{mode} is not one of either \code{"and"} or \code{"or"}.

This parameter only applies if \code{search} is a named character vector.}
}
\value{
A character vector of the S3 class \verb{<AsIS>}, with a formatted search
term which can be supplied to \code{openFDA()}.
}
\description{
This function is a helper for constructing search queries. Whilst it  handles
some of the available formatting for openFDA APIs, it does not recapture all
of the search term syntax available to you. To get a full appreciation of the
openFDA search syntax, see \url{https://open.fda.gov/apis/advanced-syntax/}.
}
\note{
This function does not check that you're providing accurate field names or
search terms. It is up to you to make sure you've provided correctly spelt
fields and search terms.
}
\examples{
# Provide a formatted search string and the function will do no formatting
format_search_term("openfda.generic_name:verapamil")

# Provide a named vector and the function will format it for you
format_search_term(c("openfda.generic_name" = "verapamil"))

# If providing multiple elements in your search term, use `exact = FALSE`
# to prevent the function from surrounding the term with double quotes.
format_search_term(c("openfda.generic_name" = "verapamil+amlodipine"),
                   exact = FALSE)

# Provide a longer named vector and function will merge these with an OR
# operator
format_search_term(c("openfda.generic_name" = "verapamil",
                     "openfda.manufacturer_name" = "glaxo*"))

# Or you can set the `mode` argument to merge your search terms with an AND
# operator
format_search_term(c("openfda.generic_name" = "verapamil",
                     "openfda.manufacturer_name" = "glaxo*"),
                   mode = "and")
}
\seealso{
\itemize{
\item \code{\link[=format_sort_term]{format_sort_term()}} performs similar formatting for the \code{sort} component
of an openFDA query.
\item \code{\link[=I]{I()}} generates vectors with the \verb{<AsIs>} S3 class.
\item \code{\link[httr2:req_url]{httr2::req_url()}} documents why \code{\link[=I]{I()}} is applied to the output of this
function.
}
}
