% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mydata.R
\docType{data}
\name{mydata}
\alias{mydata}
\title{Example air quality monitoring data for openair}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 65533 rows and 10 columns.
}
\source{
\code{mydata} was compiled from data archived in the London Air Quality
Archive.  See \url{https://londonair.org.uk} for site details.
}
\usage{
mydata
}
\description{
The \code{mydata} dataset is provided as an example dataset as part of the openair
package. The dataset contains hourly measurements of air pollutant
concentrations, wind speed and wind direction collected at the Marylebone
(London) air quality monitoring supersite between 1st January 1998 and 23rd
June 2005.
}
\details{
\describe{
\item{date}{Observation date/time stamp in year-month-day hour:minute:second
format (POSIXct).}
\item{ws}{Wind speed, in m/s, as numeric vector.}
\item{wd}{Wind direction, in degrees from North, as a numeric vector.}
\item{nox}{Oxides of nitrogen concentration, in ppb, as a numeric vector.}
\item{no2}{Nitrogen dioxide concentration, in ppb, as a numeric vector.}
\item{o3}{Ozone concentration, in ppb, as a numeric vector.}
\item{pm10}{Particulate PM10 fraction measurement, in ug/m3 (raw TEOM), as a
numeric vector.}
\item{so2}{Sulfur dioxide concentration, in ppb, as a numeric vector.}
\item{co}{Carbon monoxide concentration, in ppm, as a numeric vector.}
\item{pm25}{Particulate PM2.5 fraction measurement, in ug/m3, as a numeric
vector.}
}
}
\note{
\link[=openair-package]{openair} functions generally require data frames with
a field "date" that can be in either \code{POSIXct} or \code{Date} format
}
\examples{
# basic structure
head(mydata)
}
\keyword{datasets}
