% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STapprox.R
\name{STapprox}
\alias{STapprox}
\title{Skew-t approximation to a density evaluated on a sparse grid}
\usage{
STapprox(x, lfx)
}
\arguments{
\item{x}{Vector containing a grid of values on the density support and covering the posterior mode.}

\item{lfx}{Log density values on the grid \code{x} (possibly up to an additive constant)}
}
\value{
A list containing
\itemize{
\item{\code{dp} : \verb{ }}{Parameters of the approximating skew-t density.}
\item{\code{fitted.moments} : \verb{ }}{Mean, variance, skewness, kurtosis of the approximating skew-t.}
}
}
\description{
Skew-t approximation to a density evaluated on a sparse grid
}
\examples{
library(ordgam)

## Density to be approximated by a Skew-t
dtarget = function(x) dgamma(x,10,2)
curve(dtarget(x),0,15,lwd=2,ylab="Density")

## Values of the target density on a sparse grid
ngrid = 6 ## Sparse grid size
xgrid = seq(2,8,length=ngrid) ## Grid
lfx = log(dtarget(xgrid)) ## Log values

## Skew-t approximation
dp = ordgam::STapprox(xgrid,lfx)$dp
curve(sn::dst(x,dp=dp),add=TRUE,lwd=2,lty=2,col=2)
points(xgrid,exp(lfx))
legend("topright",legend=c("Target density","Skew-t approx."),
       col=1:2,lty=1:2,lwd=2,bty="n")

}
\references{
Lambert, P. and Gressani, 0. (2023) Penalty parameter selection and asymmetry corrections
to Laplace approximations in Bayesian P-splines models. Statistical Modelling. <doi:10.1177/1471082X231181173>. Preprint: <arXiv:2210.01668>.
}
\seealso{
\code{\link{SNapprox}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
