% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_num_raster.R
\name{extract_num_raster}
\alias{extract_num_raster}
\title{Extract Numeric Raster Values by Polygons}
\usage{
extract_num_raster(spat_raster_multi, sf_hex_grid)
}
\arguments{
\item{spat_raster_multi}{A SpatRaster object (single or multilayer numeric raster).}

\item{sf_hex_grid}{An sf object with polygon geometries (e.g., H3 hexagons).}
}
\value{
An sf object with additional columns for each raster layer.
}
\description{
Extracts numeric raster values for each polygon in an sf object.
Uses exactextractr to compute the weighted mean using the area of overlap.
}
\examples{
\dontrun{

r <- terra::rast(system.file("raster/bio.tif", package = "spData"))
grid_sf <- get_h3_grid(st_as_sf(st_bbox(r)), resolution = 6)
result_sf <- extract_num_raster(r, grid_sf)
head(result_sf)
}

}
