% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_temporal_functions.R
\name{pbdb_temp_range}
\alias{pbdb_temp_range}
\title{Temporal range of taxa}
\usage{
pbdb_temp_range(
  data,
  rank = c("species", "genus", "family", "order", "class", "phylum"),
  col = "#0000FF",
  names = TRUE,
  do_plot = TRUE
)
}
\arguments{
\item{data}{Data frame from a query to PaleobioDB as returned by
\code{\link[=pbdb_occurrences]{pbdb_occurrences()}}.  Important: it is required to have
information about the taxonomic classification of the occurrences
in the data frame, to do that set the \code{show} parameter to
\code{"class"} or \code{"classext"} (see Examples).}

\item{rank}{The taxon rank to be analyzed.  The default value is
\code{"species"}.}

\item{col}{Colour of the bars in the plot.}

\item{names}{Logical indicating whether to include the name of the
taxa in the plot (\code{TRUE} by default).}

\item{do_plot}{Logical value indicating whether to produce a plot
(\code{TRUE} by default).}
}
\value{
A data frame with the time span of the taxa selected
(species, genera, etc.).
}
\description{
Returns a data frame with the temporal range of the taxa within a
selected rank (species, genera, families, etc.), and optionally
generates a plot from it.
}
\examples{
\dontrun{
  canis_quaternary <- pbdb_occurrences(
    limit = "all", base_name = "Canis", interval = "Quaternary",
    show = c("coords", "classext"), vocab = "pbdb"
  )
  pbdb_temp_range(canis_quaternary, rank = "species", names = FALSE)
}
}
