% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relR_samplesize.R
\name{relR_samplesize}
\alias{relR_samplesize}
\title{Calculate sample size needed to detect differential transmission}
\usage{
relR_samplesize(
  R_a,
  R_b,
  p_a,
  N,
  alpha = 0.05,
  alternative = c("two_sided", "less", "greater"),
  power = 0.8,
  sensitivity = 1,
  specificity = 1,
  overdispersion = NULL,
  correct_for_imbalance = FALSE
)
}
\arguments{
\item{R_a}{Numeric (Positive). The assumed R among the group in the
denominator of the ratio. Input value must be greater than 0.}

\item{R_b}{Numeric (Positive). The assumed R among the group in the
numerator of the ratio. Input value must be greater than 0.}

\item{p_a}{Numeric. The proportion of the population in group \code{a}. Must be
between 0 and 1.}

\item{N}{Numeric (Positive). The size of the infected pool. Only one of
\code{rho} or \code{N} should be specified.}

\item{alpha}{Numeric. The desired alpha level. Default: 0.05}

\item{alternative}{Character. Specifies the alternative hypothesis.
Must be: \code{two_sided} (Default), \code{less}, or \code{greater}}

\item{power}{Numeric. The desired power. Must be a value between 0 and 1.
Default: 0.8.}

\item{sensitivity}{Numeric. The sensitivity of the linkage criteria.
Must be between 0 and 1. Default: 1.}

\item{specificity}{Numeric. The specificity of the linkage criteria.
Must be between 0 and 1. Default: 1.}

\item{overdispersion}{Numeric (Positive). An overdispersion parameter, set
if the assumed distribution of the number of edges is negative binomial.
If \code{NULL} the assumed distribution is Poisson (equivalent to an
overdispersion parameter of infinity) Default: \code{NULL} Note that this is
equivalent to setting the overdispersion parameter to \code{Inf}.}

\item{correct_for_imbalance}{Logical. Should we use simulation to correct
for being over/under powered due to large differences in group sizes?
Default: \code{FALSE}.}
}
\value{
Sample size needed achieve desired type I and II error rates
under assumptions. Will return \code{NA} and throw a warning if impossible.
}
\description{
Function for calculating sample size given a set of assumptions. This is the
high level wrapper function that users should call directly.
}
\examples{

## Calculate sample size needed to detect a difference between groups where 
## group A has a reproductive value of 2, group B has a reproductive 
## value of 2.5, the groups are balanced, and the total outbreak size is 
## 1,000

relR_samplesize(R_a = 2, 
                R_b = 2.5, 
                p_a = 0.5,
                N = 1000)

## Update the above calculation to account for imperfect sensitivity = 0.7
relR_samplesize(R_a = 2, 
                R_b = 2.5, 
                p_a = 0.5,
                N = 1000,
                sensitivity = 0.7)

## Update the above calculation to allow for overdispersion
relR_samplesize(R_a = 2, 
                R_b = 2.5, 
                p_a = 0.5,
                N = 1000,
                sensitivity = 0.7,
                overdispersion = 2000)

}
