% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/head.piar_index.R
\name{head.piar_index}
\alias{head.piar_index}
\alias{tail.piar_index}
\title{Return the first/last parts of an index}
\usage{
\method{head}{piar_index}(x, n = 6L, ...)

\method{tail}{piar_index}(x, n = 6L, ...)
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elementary_index]{elementary_index()}}.}

\item{n}{See \code{\link[=head]{head()}}/\code{\link[=tail]{tail()}}. The default takes the
first/last 6 levels of \code{x}.}

\item{...}{Not currently used.}
}
\value{
A price index that inherits from the same class as \code{x}.
}
\description{
Extract the first/last parts of an index as if it were a matrix.
}
\examples{
index <- as_index(matrix(1:9, 3))

head(index, 1)

tail(index, 1)

}
\seealso{
Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}},
\code{\link{as.data.frame.piar_index}()},
\code{\link{as.ts.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{is.na.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}},
\code{\link{merge.piar_index}()},
\code{\link{split.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{window.piar_index}()}
}
\concept{index methods}
