#' get_usergroups_list fetch all usergroups
#'
#' @param token login token generated by \code{\link{get_login_token}}
#'
#' @return data.frame
#' @export
#'
get_usergroups_list <- function(token) {
  get_generic_list(token, 0, "/api/user-groups/v1",
                   c('type', 'id', 'name', 'created_at', 'updated_at'),
                   c('created_at', 'updated_at'))
}


#' get_usergroup_members
#'
#' @param token login token generated by \code{\link{get_login_token}}
#' @param usergroup_id usergroup (see \code{\link{get_usergroups_list}})
#'
#' @return data.frame
#' @export

get_usergroup_members <- function(token, usergroup_id) {
  get_generic_list(token, 0, glue::glue("/api/user-groups/v1/{usergroup_id}/users"),
                   c('type', 'id', 'email'),
                   c())
}
