is_dimension_numeric <- function(dimension) {
  logical_value <- get_type_of_dimension(dimension) %in% c("int", "float")
  if (length(logical_value) == 1) {
    return(logical_value)
  } else {
    return(FALSE)
  }
}

#' @importFrom rlang .data
get_type_of_dimension <- function(dimension) {
  # types as of https://developers.piwik.pro/en/latest/custom_reports/columns.html
  types <- tibble::tribble(
                             ~Dimension.Name,                            ~Column.ID,    ~Scope,        ~Type,   ~Database.Type, ~Nullable,                                        ~Notes,
                                "Visitor ID",                          "visitor_id", "session",        "hex",         "uint64",     FALSE,                  "by default in Raw data API",
                                   "User ID",                             "user_id", "session",        "str",         "string",     FALSE,                                            NA,
                                 "Cookie ID",                           "cookie_id", "session",        "hex",         "uint64",     FALSE,                "not available in Queries API",
                         "Returning visitor",                   "visitor_returning", "session", "[int, str]",          "uint8",     FALSE,                      "visitor_returning.json",
                            "Session number",              "visitor_session_number", "session",        "int",         "uint16",     FALSE,                                            NA,
                   "Days since last session",     "visitor_days_since_last_session", "session",        "int",         "uint16",      TRUE,                                            NA,
                  "Days since first session",    "visitor_days_since_first_session", "session",        "int",         "uint16",      TRUE,                                            NA,
                          "Days since order",            "visitor_days_since_order", "session",        "int",         "uint16",      TRUE,                                            NA,
                         "Events in session",                "session_total_events", "session",        "int",         "uint16",     FALSE,                                            NA,
                              "Session time",                  "session_total_time", "session",        "int",         "uint32",     FALSE,                                            NA,
                     "Page views in session",            "session_total_page_views", "session",        "int",         "uint16",     FALSE,                                            NA,
                       "Outlinks in session",              "session_total_outlinks", "session",        "int",         "uint16",     FALSE,                                            NA,
                      "Downloads in session",             "session_total_downloads", "session",        "int",         "uint16",     FALSE,                                            NA,
                  "Site searches in session",         "session_total_site_searches", "session",        "int",         "uint16",     FALSE,                                            NA,
                  "Custom events in session",         "session_total_custom_events", "session",        "int",         "uint16",     FALSE,                                            NA,
            "Content impressions in session",   "session_total_content_impressions", "session",        "int",         "uint16",     FALSE,                                            NA,
           "Content interactions in session",  "session_total_content_interactions", "session",        "int",         "uint16",     FALSE,                                            NA,
               "Goal conversions in session",      "session_total_goal_conversions", "session",        "int",         "uint16",     FALSE,                                            NA,
          "Ecommerce conversions in session", "session_total_ecommerce_conversions", "session",        "int",         "uint16",     FALSE,                                            NA,
                "Abandoned carts in session",       "session_total_abandoned_carts", "session",        "int",         "uint16",     FALSE,                                            NA,
              "Unique page views in session",           "session_unique_page_views", "session",        "int",         "uint16",     FALSE,                                            NA,
                "Unique outlinks in session",             "session_unique_outlinks", "session",        "int",         "uint16",     FALSE,                                            NA,
               "Unique downloads in session",            "session_unique_downloads", "session",        "int",         "uint16",     FALSE,                                            NA,
           "Unique site searches in session",             "session_unique_searches", "session",        "int",         "uint16",     FALSE,                                            NA,
           "Unique custom events in session",        "session_unique_custom_events", "session",        "int",         "uint16",     FALSE,                                            NA,
     "Unique content impressions in session",  "session_unique_content_impressions", "session",        "int",         "uint16",     FALSE,                                            NA,
    "Unique content interactions in session", "session_unique_content_interactions", "session",        "int",         "uint16",     FALSE,                                            NA,
                "Goals converted in session",                       "session_goals", "session",      "array", "array of int32",     FALSE,                "not available in Queries API",
                            "Shopping stage",            "session_ecommerce_status", "session", "[int, str]",          "uint8",     FALSE,               "session_ecommerce_status.json",
                                    "Source",                              "source", "session",        "str",         "string",     FALSE,                                            NA,
                                    "Medium",                              "medium", "session",        "str",         "string",     FALSE,                                            NA,
                             "Source/Medium",                       "source_medium", "session",        "str",         "string",     FALSE,                                            NA,
                                   "Keyword",                             "keyword", "session",        "str",         "string",     FALSE,                                            NA,
                                   "Channel",                       "referrer_type", "session", "[int, str]",          "uint8",     FALSE,                          "referrer_type.json",
                              "Referrer URL",                        "referrer_url", "session",        "str",         "string",     FALSE,                                            NA,
                             "Campaign name",                       "campaign_name", "session",        "str",         "string",     FALSE,                                            NA,
                               "Campaign ID",                         "campaign_id", "session",        "str",         "string",     FALSE,                                            NA,
                          "Campaign content",                    "campaign_content", "session",        "str",         "string",     FALSE,                                            NA,
                           "Google Click ID",                      "campaign_gclid", "session",        "str",         "string",      TRUE,                "not available in Queries API",
                          "Operating system",                    "operating_system", "session", "[str, str]",      "string(3)",      TRUE,                       "operating_system.json",
                  "Operating system version",            "operating_system_version", "session",        "str",         "string",     FALSE,                                            NA,
                            "Browser engine",                      "browser_engine", "session",        "str",         "string",     FALSE,                                            NA,
                              "Browser name",                        "browser_name", "session", "[str, str]",      "string(2)",      TRUE,                           "browser_name.json",
                           "Browser version",                     "browser_version", "session",        "str",         "string",     FALSE,                                            NA,
                          "Browser language",             "browser_language_iso639", "session", "[str, str]",      "string(2)",      TRUE,                "browser_language_iso639.json",
                       "Browser fingerprint",                 "browser_fingerprint", "session",        "int",         "uint64",     FALSE,                "not available in Queries API",
                               "Device type",                         "device_type", "session", "[int, str]",          "uint8",      TRUE,                            "device_type.json",
                              "Device brand",                        "device_brand", "session", "[str, str]",      "string(2)",      TRUE,                           "device_brand.json",
                              "Device model",                        "device_model", "session",        "str",         "string",     FALSE,                                            NA,
                                "Resolution",                          "resolution", "session",        "str",         "string",      TRUE,                                            NA,
                          "Resolution width",                    "resolution_width", "session",        "int",         "uint16",      TRUE,                                            NA,
                         "Resolution height",                   "resolution_height", "session",        "int",         "uint16",      TRUE,                                            NA,
                                "PDF plugin",                          "plugin_pdf", "session",   "int(0,1)",          "uint8",     FALSE,                                            NA,
                              "Flash plugin",                        "plugin_flash", "session",   "int(0,1)",          "uint8",     FALSE,                                            NA,
                               "Java plugin",                         "plugin_java", "session",   "int(0,1)",          "uint8",     FALSE,                                            NA,
                           "Director plugin",                     "plugin_director", "session",   "int(0,1)",          "uint8",     FALSE,                                            NA,
                          "QuickTime plugin",                    "plugin_quicktime", "session",   "int(0,1)",          "uint8",     FALSE,                                            NA,
                         "RealPlayer plugin",                   "plugin_realplayer", "session",   "int(0,1)",          "uint8",     FALSE,                                            NA,
               "Windows Media Player plugin",                 "plugin_windowsmedia", "session",   "int(0,1)",          "uint8",     FALSE,                                            NA,
                              "Gears plugin",                        "plugin_gears", "session",   "int(0,1)",          "uint8",     FALSE,                                            NA,
                        "Silverlight plugin",                  "plugin_silverlight", "session",   "int(0,1)",          "uint8",     FALSE,                                            NA,
                            "Cookie support",                       "plugin_cookie", "session",   "int(0,1)",          "uint8",     FALSE,                                            NA,
                                 "Continent",         "location_continent_iso_code", "session", "[str, str]",      "string(2)",      TRUE,            "location_continent_iso_code.json",
                                   "Country",               "location_country_name", "session", "[str, str]",         "string",      TRUE,                "ISO 3166-2 codes (e.g. PL)",
                               "Subdivision",         "location_subdivision_1_name", "session", "[str, str]",         "string",      TRUE,             "ISO 3166-2 codes (e.g. PL-DS)",
                             "Subdivision 2",         "location_subdivision_2_name", "session", "[str, str]",         "string",      TRUE,              "ISO 3166-2 codes (e.g. ES-M)",
                                      "City",                  "location_city_name", "session", "[int, str]",         "string",      TRUE, "unique identifiers as specified by GeoNames",
                    "Designated market area",                 "location_metro_code", "session", "[str, str]",      "string(3)",      TRUE,                    "location_metro_code.json",
                                  "Latitude",                   "location_latitude", "session",      "float",        "float64",      TRUE,                                            NA,
                                 "Longitude",                  "location_longitude", "session",      "float",        "float64",      TRUE,                                            NA,
                                  "Provider",                   "location_provider", "session",        "str",         "string",     FALSE,                                            NA,
                              "Organization",               "location_organization", "session",        "str",         "string",     FALSE,                                            NA,
                          "Session exit URL",                    "session_exit_url", "session",        "str",         "string",     FALSE,                                            NA,
                        "Session exit title",                  "session_exit_title", "session",        "str",         "string",     FALSE,                                            NA,
                         "Session entry URL",                   "session_entry_url", "session",        "str",         "string",     FALSE,                                            NA,
                       "Session entry title",                 "session_entry_title", "session",        "str",         "string",     FALSE,                                            NA,
                        "Session second URL",                  "session_second_url", "session",        "str",         "string",     FALSE,                                            NA,
                      "Session second title",                "session_second_title", "session",        "str",         "string",     FALSE,                                            NA,
                            "Session bounce",                           "is_bounce", "session",   "int(0,1)",          "uint8",     FALSE,                                            NA,
                                  "Event ID",                            "event_id",   "event",        "int",         "uint64",     FALSE,                  "by default in Raw data API",
                                "Session ID",                          "session_id", "session",        "int",         "uint64",     FALSE,                  "by default in Raw data API",
                                 "Exit view",                             "is_exit",   "event",   "int(0,1)",          "uint8",     FALSE,                "not available in Queries API",
                                "Entry view",                            "is_entry",   "event",   "int(0,1)",          "uint8",     FALSE,                "not available in Queries API",
                                "Event type",                          "event_type",   "event", "[int, str]",          "uint8",     FALSE,                             "event_type.json",
                                  "Page URL",                           "event_url",   "event",        "str",         "string",     FALSE,                                            NA,
                                "Page title",                         "event_title",   "event",        "str",         "string",     FALSE,                                            NA,
                               "Outlink URL",                         "outlink_url",   "event",        "str",         "string",     FALSE,                                            NA,
                              "Download URL",                        "download_url",   "event",        "str",         "string",     FALSE,                                            NA,
                            "Search keyword",                      "search_keyword",   "event",        "str",         "string",     FALSE,                                            NA,
                           "Search category",                     "search_category",   "event",        "str",         "string",     FALSE,                                            NA,
                      "Search results count",                "search_results_count",   "event",        "int",         "uint16",      TRUE,                                            NA,
                     "Custom event category",               "custom_event_category",   "event",        "str",         "string",     FALSE,                                            NA,
                       "Custom event action",                 "custom_event_action",   "event",        "str",         "string",     FALSE,                                            NA,
                         "Custom event name",                   "custom_event_name",   "event",        "str",         "string",     FALSE,                                            NA,
                        "Custom event value",                  "custom_event_value",   "event",      "float",        "float64",      TRUE,                                            NA,
                              "Content name",                        "content_name",   "event",        "str",         "string",     FALSE,                                            NA,
                             "Content piece",                       "content_piece",   "event",        "str",         "string",     FALSE,                                            NA,
                            "Content target",                      "content_target",   "event",        "str",         "string",     FALSE,                                            NA,
                    "Previous page view URL",                  "previous_event_url",   "event",        "str",         "string",     FALSE,                                            NA,
                  "Previous page view title",                "previous_event_title",   "event",        "str",         "string",     FALSE,                                            NA,
                        "Next page view URL",                      "next_event_url",   "event",        "str",         "string",     FALSE,                                            NA,
                      "Next page view title",                    "next_event_title",   "event",        "str",         "string",     FALSE,                                            NA,
                               "Event index",                         "event_index",   "event",        "int",         "uint16",     FALSE,                "not available in Queries API",
                           "Page view index",                     "page_view_index",   "event",        "int",         "uint16",      TRUE,                "not available in Queries API",
                              "Time on page",                        "time_on_page",   "event",        "int",         "uint32",      TRUE,                                            NA,
                      "Page generation time",                "page_generation_time",   "event",      "float",        "float64",      TRUE,                                            NA,
                                 "Goal name",                             "goal_id",   "event", "[int, str]",          "int32",      TRUE,                     "goal IDs from Analytics",
                              "Goal revenue",                        "goal_revenue",   "event",      "float",        "float64",      TRUE,                                            NA,
                              "Lost revenue",                        "lost_revenue",   "event",      "float",        "float64",      TRUE,                                            NA,
                                  "Order ID",                            "order_id",   "event",        "str",         "string",     FALSE,                                            NA,
                                "Item count",                          "item_count",   "event",        "int",         "uint16",      TRUE,                                            NA,
                                   "Revenue",                             "revenue",   "event",      "float",        "float64",      TRUE,                                            NA,
                        "Revenue (Subtotal)",                    "revenue_subtotal",   "event",      "float",        "float64",      TRUE,                                            NA,
                             "Revenue (Tax)",                         "revenue_tax",   "event",      "float",        "float64",      TRUE,                                            NA,
                        "Revenue (Shipping)",                    "revenue_shipping",   "event",      "float",        "float64",      TRUE,                                            NA,
                        "Revenue (Discount)",                    "revenue_discount",   "event",      "float",        "float64",      TRUE,                                            NA,
                   "Time until DOM is ready",              "timing_dom_interactive",   "event",        "int",         "uint32",      TRUE,                                            NA,
                          "Time to interact",                    "timing_event_end",   "event",        "int",         "uint32",      TRUE,                                            NA,
                  "Event custom dimension 1",            "event_custom_dimension_1",   "event",        "str",         "string",     FALSE,                                            NA,
                  "Event custom dimension 2",            "event_custom_dimension_2",   "event",        "str",         "string",     FALSE,                                            NA,
                  "Event custom dimension 3",            "event_custom_dimension_3",   "event",        "str",         "string",     FALSE,                                            NA,
                  "Event custom dimension 4",            "event_custom_dimension_4",   "event",        "str",         "string",     FALSE,                                            NA,
                  "Event custom dimension 5",            "event_custom_dimension_5",   "event",        "str",         "string",     FALSE,                                            NA,
               "Event custom variable key 1",         "event_custom_variable_key_1",   "event",        "str",         "string",     FALSE,                                            NA,
             "Event custom variable value 1",       "event_custom_variable_value_1",   "event",        "str",         "string",     FALSE,                                            NA,
               "Event custom variable key 2",         "event_custom_variable_key_2",   "event",        "str",         "string",     FALSE,                                            NA,
             "Event custom variable value 2",       "event_custom_variable_value_2",   "event",        "str",         "string",     FALSE,                                            NA,
               "Event custom variable key 3",         "event_custom_variable_key_3",   "event",        "str",         "string",     FALSE,                                            NA,
             "Event custom variable value 3",       "event_custom_variable_value_3",   "event",        "str",         "string",     FALSE,                                            NA,
               "Event custom variable key 4",         "event_custom_variable_key_4",   "event",        "str",         "string",     FALSE,                                            NA,
             "Event custom variable value 4",       "event_custom_variable_value_4",   "event",        "str",         "string",     FALSE,                                            NA,
               "Event custom variable key 5",         "event_custom_variable_key_5",   "event",        "str",         "string",     FALSE,                                            NA,
             "Event custom variable value 5",       "event_custom_variable_value_5",   "event",        "str",         "string",     FALSE,                                            NA,
                "Session custom dimension 1",          "session_custom_dimension_1", "session",        "str",         "string",     FALSE,                                            NA,
                "Session custom dimension 2",          "session_custom_dimension_2", "session",        "str",         "string",     FALSE,                                            NA,
                "Session custom dimension 3",          "session_custom_dimension_3", "session",        "str",         "string",     FALSE,                                            NA,
                "Session custom dimension 4",          "session_custom_dimension_4", "session",        "str",         "string",     FALSE,                                            NA,
                "Session custom dimension 5",          "session_custom_dimension_5", "session",        "str",         "string",     FALSE,                                            NA,
             "Session custom variable key 1",       "session_custom_variable_key_1", "session",        "str",         "string",     FALSE,                                            NA,
           "Session custom variable value 1",     "session_custom_variable_value_1", "session",        "str",         "string",     FALSE,                                            NA,
             "Session custom variable key 2",       "session_custom_variable_key_2", "session",        "str",         "string",     FALSE,                                            NA,
           "Session custom variable value 2",     "session_custom_variable_value_2", "session",        "str",         "string",     FALSE,                                            NA,
             "Session custom variable key 3",       "session_custom_variable_key_3", "session",        "str",         "string",     FALSE,                                            NA,
           "Session custom variable value 3",     "session_custom_variable_value_3", "session",        "str",         "string",     FALSE,                                            NA,
             "Session custom variable key 4",       "session_custom_variable_key_4", "session",        "str",         "string",     FALSE,                                            NA,
           "Session custom variable value 4",     "session_custom_variable_value_4", "session",        "str",         "string",     FALSE,                                            NA,
             "Session custom variable key 5",       "session_custom_variable_key_5", "session",        "str",         "string",     FALSE,                                            NA,
           "Session custom variable value 5",     "session_custom_variable_value_5", "session",        "str",         "string",     FALSE,                                            NA,
                                 "Timestamp",                           "timestamp", "session",       "date", "not applicable",     FALSE,                  "by default in Raw data API",
                                "Local hour",                          "local_hour", "session",        "int", "not applicable",     FALSE,                                            NA,
                      "Time of redirections",                   "redirections_time",   "event",        "int", "not applicable",      TRUE,                                            NA,
                        "Domain Lookup Time",                  "domain_lookup_time",   "event",        "int", "not applicable",      TRUE,                                            NA,
                    "Server Connection Time",              "server_connection_time",   "event",        "int", "not applicable",      TRUE,                                            NA,
                      "Server Response Time",                "server_response_time",   "event",        "int", "not applicable",      TRUE,                                            NA,
                       "Page Rendering Time",                 "page_rendering_time",   "event",        "int", "not applicable",      TRUE,                                            NA,
                              "IPv4 address",                        "ipv4_address", "session",       "ipv4", "not applicable",      TRUE,                                            NA,
                              "IPv6 address",                        "ipv6_address", "session",       "ipv6", "not applicable",      TRUE,                                            NA,
                              "Website Name",                        "website_name", "session", "[str, str]", "not applicable",     FALSE,                                "website UUID"
    )
  types %>%
    dplyr::filter(grepl(paste0("^", dimension), .data$Column.ID)) %>%
    dplyr::pull(.data$Type)
}
