% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_overlap_vars.R
\name{plot_overlap_vars}
\alias{plot_overlap_vars}
\title{Plot the overlap of variables}
\usage{
plot_overlap_vars(
  .data,
  treatment,
  confounders,
  plot_type = c("histogram", "density")
)
}
\arguments{
\item{.data}{dataframe}

\item{treatment}{character. Name of the treatment column within .data}

\item{confounders}{character list of column names denoting confounders within .data}

\item{plot_type}{the plot type, one of c('histogram', 'density'). Defaults to 'histogram'}
}
\value{
ggplot object
}
\description{
Plot histograms showing the overlap between variables by treatment status.
}
\examples{
data(lalonde)
plot_overlap_vars(
 .data = lalonde,
 treatment = 'treat',
 confounders = c('age', 'educ'),
 plot_type = 'Histogram'
)
}
\seealso{
\code{\link{plot_overlap_pScores}}
}
\author{
George Perrett, Joseph Marlo
}
