% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-simulations.R
\name{simulate_group_inter}
\alias{simulate_group_inter}
\title{Simulate PLSMM}
\usage{
simulate_group_inter(
  N = 50,
  n_mvnorm = 100,
  grouped = TRUE,
  timepoints = 3:5,
  nonpara_inter = TRUE,
  sample_from,
  cos = FALSE,
  A_vec = c(1, 1.5)
)
}
\arguments{
\item{N}{Number of subjects.}

\item{n_mvnorm}{Number of covariate generates from a multivariate normal distribution.}

\item{grouped}{Logical indicating whether to include grouping effect.}

\item{timepoints}{Vector specifying timepoints for each subject.}

\item{nonpara_inter}{Logical indicating whether the nonparametric function is specific to each group.}

\item{sample_from}{Vector of time points to sample from.}

\item{cos}{Logical indicating whether to use cosine function for second group.}

\item{A_vec}{Vector of amplitudes for the nonlinear functions for each group.}
}
\value{
A list with three components:
\item{sim}{Simulated data frame.}
\item{phi}{Individual random intercepts.}
\item{f_val}{Values of the nonlinear functions.}
}
\description{
Simulate a partial linear semiparametric mixed-effects model.
}
\examples{

simulate_group_inter(
  N = 50, n_mvnorm = 100, grouped = TRUE,
  timepoints = 3:5, nonpara_inter = TRUE,
  sample_from = seq(0, 10, by = 0.1), cos = FALSE, A_vec = c(1, 1.5)
)

}
