% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/receptiveness.R
\name{receptiveness}
\alias{receptiveness}
\title{Conversational Receptiveness}
\usage{
receptiveness(texts, num_mc_cores = 1)
}
\arguments{
\item{texts}{character A vector of texts, each of which will be tallied for politeness features.}

\item{num_mc_cores}{integer Number of cores for parallelization.}
}
\value{
a vector with receptiveness scores.
}
\description{
Pre-trained model to detect conversational receptiveness
}
\details{
This is a wrapper around a pre-trained model of "conversational receptiveness".
The model trained from Study 1 of that paper can be applied to new text with a single function.
This model requires grammar parsing via SpaCy. Please see \code{\link[spacyr:spacyr]{spacyr}} for details on installation.
}
\examples{


\dontrun{
data("phone_offers")

receptiveness(phone_offers$message)

}

}
\references{
Yeomans, M., Minson, J., Collins, H., Chen, F. & Gino, F. (2020). Conversational Receptiveness: Improving Engagement with Opposing Views. OBHDP.
}
